/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.modify.request.QuadAccSink;

public class QuadDataAccSink
extends QuadAccSink {
    public QuadDataAccSink(Sink<Quad> sink) {
        super(sink);
    }

    @Override
    protected void check(Triple t) {
        if (Var.isVar(this.getGraph())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (Var.isVar(t.getSubject()) || Var.isVar(t.getPredicate()) || Var.isVar(t.getObject())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (t.getSubject().isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in data", -1, -1);
        }
    }

    @Override
    protected void check(Quad quad) {
        if (Var.isVar(quad.getGraph()) || Var.isVar(quad.getSubject()) || Var.isVar(quad.getPredicate()) || Var.isVar(quad.getObject())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (quad.getSubject().isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in quad data", -1, -1);
        }
    }
}

