/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.util.function.Supplier;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.resultset.rw.ResultsReader;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.Txn;

public class ReadAnything {
    public static SPARQLResult read(String url) {
        return ReadAnything.read(url, ARQ.getContext());
    }

    public static SPARQLResult read(String url, Context context) {
        TypedInputStream in = StreamManager.get(context).open(url);
        ContentType ct = WebContent.determineCT(in.getContentType(), null, url);
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (RDFLanguages.isTriples(lang)) {
            Model model = ModelFactory.createDefaultModel();
            Supplier<SPARQLResult> r = () -> {
                StreamRDF sink = StreamRDFLib.graph(model.getGraph());
                RDFParser.source(in).lang(lang).parse(sink);
                return new SPARQLResult(model);
            };
            if (model.supportsTransactions()) {
                return (SPARQLResult)model.calculateInTxn(r);
            }
            return r.get();
        }
        if (RDFLanguages.isQuads(lang)) {
            Dataset ds = DatasetFactory.create();
            Supplier<SPARQLResult> r = () -> {
                StreamRDF sink = StreamRDFLib.dataset(ds.asDatasetGraph());
                RDFParser.source(in).lang(lang).parse(sink);
                return new SPARQLResult(ds);
            };
            if (ds.supportsTransactions()) {
                return Txn.calculateWrite(ds, r);
            }
            return r.get();
        }
        if (ResultSetReaderRegistry.isRegistered(lang)) {
            return ResultsReader.create().forceLang(lang).context(context).build().readAny(in.getInputStream());
        }
        throw new RiotException("Failed to determine: lang = " + lang);
    }
}

