/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.lang.LangEngine;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.graph.NodeConst;

public class BindingInputStream
extends LangEngine
implements Iterator<Binding>,
Closeable {
    private final IteratorTuples iter = new IteratorTuples();

    public BindingInputStream(InputStream in) {
        this(TokenizerFactory.makeTokenizerUTF8(in));
    }

    public BindingInputStream(Tokenizer tokenizer) {
        this(tokenizer, BindingInputStream.profile());
    }

    static ParserProfile profile() {
        Prologue prologue = new Prologue(PrefixMapFactory.createForInput(), IRIResolver.createNoResolve());
        ErrorHandler handler = ErrorHandlerFactory.getDefaultErrorHandler();
        FactoryRDF factory = RiotLib.factoryRDF(LabelToNode.createUseLabelAsGiven());
        ParserProfile profile = RiotLib.createParserProfile(factory, handler, false);
        return profile;
    }

    private BindingInputStream(Tokenizer tokenizer, ParserProfile profile) {
        super(tokenizer, profile, profile.getErrorHandler());
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Binding next() {
        return (Binding)this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    public List<Var> vars() {
        return Collections.unmodifiableList(this.iter.vars);
    }

    public void close() {
        this.tokens.close();
    }

    class IteratorTuples
    extends IteratorSlotted<Binding> {
        private Binding lastLine;
        List<Var> vars = new ArrayList<Var>();
        protected static final String KW_TRUE = "true";
        protected static final String KW_FALSE = "false";

        public IteratorTuples() {
            this.directives();
        }

        private void directives() {
            while (BindingInputStream.this.lookingAt(TokenType.KEYWORD)) {
                Token t = BindingInputStream.this.peekToken();
                if (t.getImage().equalsIgnoreCase("VARS")) {
                    BindingInputStream.this.nextToken();
                    this.directiveVars();
                    continue;
                }
                if (!t.getImage().equalsIgnoreCase("PREFIX")) break;
                BindingInputStream.this.nextToken();
                this.directivePrefix();
            }
        }

        protected Binding moveToNext() {
            this.directives();
            BindingMap binding = BindingFactory.create();
            int i = 0;
            while (!BindingInputStream.this.lookingAt(TokenType.DOT)) {
                if (i >= this.vars.size()) {
                    BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "Too many items in a line.  Expected " + this.vars.size(), new Object[0]);
                }
                Var v = this.vars.get(i);
                Token token = BindingInputStream.this.nextToken();
                if (!token.hasType(TokenType.MINUS)) {
                    Node n;
                    if (token.hasType(TokenType.STAR)) {
                        n = this.lastLine.get(v);
                    } else if (token.hasType(TokenType.BNODE)) {
                        n = NodeFactory.createBlankNode((String)NodeFmtLib.decodeBNodeLabel(token.getImage()));
                    } else if (token.hasType(TokenType.KEYWORD)) {
                        String lex = token.getImage();
                        if (lex.equals(KW_TRUE)) {
                            n = NodeConst.nodeTrue;
                        } else if (lex.equals(KW_FALSE)) {
                            n = NodeConst.nodeFalse;
                        } else {
                            BindingInputStream.this.exception(token, "Keyword out of place: " + lex, new Object[0]);
                            n = null;
                        }
                    } else {
                        n = BindingInputStream.this.profile.create(null, token);
                    }
                    binding.add(v, n);
                }
                ++i;
            }
            if (BindingInputStream.this.eof()) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "Line does not end with a DOT", new Object[0]);
            }
            Token dot = BindingInputStream.this.nextToken();
            if (i != this.vars.size()) {
                Var v = this.vars.get(this.vars.size() - 1);
                BindingInputStream.this.exception(dot, "Too many items in a line.  Expected " + this.vars.size(), new Object[0]);
            }
            this.lastLine = binding;
            return binding;
        }

        protected boolean hasMore() {
            return BindingInputStream.this.moreTokens();
        }

        private void directiveVars() {
            this.vars.clear();
            while (!BindingInputStream.this.eof() && !BindingInputStream.this.lookingAt(TokenType.DOT)) {
                Token t = BindingInputStream.this.nextToken();
                if (!t.hasType(TokenType.VAR)) {
                    BindingInputStream.this.exception(t, "VARS requires a list of variables (found '" + t + "')", new Object[0]);
                }
                Var v = Var.alloc(t.getImage());
                this.vars.add(v);
            }
            BindingInputStream.this.nextToken();
        }

        private void directivePrefix() {
            if (!BindingInputStream.this.lookingAt(TokenType.PREFIXED_NAME)) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "PREFIX requires a prefix (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            if (BindingInputStream.this.peekToken().getImage2().length() != 0) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "PREFIX requires a prefix and no suffix (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            String prefix = BindingInputStream.this.peekToken().getImage();
            BindingInputStream.this.nextToken();
            if (!BindingInputStream.this.lookingAt(TokenType.IRI)) {
                BindingInputStream.this.exception(BindingInputStream.this.peekToken(), "@prefix requires an IRI (found '" + BindingInputStream.this.peekToken() + "')", new Object[0]);
            }
            String iriStr = BindingInputStream.this.peekToken().getImage();
            IRI iri = BindingInputStream.this.profile.makeIRI(iriStr, BindingInputStream.this.currLine, BindingInputStream.this.currCol);
            BindingInputStream.this.profile.getPrefixMap().add(prefix, iri);
            BindingInputStream.this.nextToken();
            BindingInputStream.this.expect("PREFIX directive not terminated by a dot", TokenType.DOT);
        }
    }
}

