/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.compose;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.IdentityFinishCollector;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.util.compose.DatasetLib;
import org.apache.jena.system.Txn;

public abstract class DatasetCollector
implements IdentityFinishCollector.UnorderedIdentityFinishCollector<Dataset, Dataset> {
    public Supplier<Dataset> supplier() {
        return DatasetFactory::createTxnMem;
    }

    public ConcurrentDatasetCollector concurrent() {
        return new ConcurrentDatasetCollector(this);
    }

    static DatasetCollector union() {
        return new UnionDatasetCollector();
    }

    static DatasetCollector intersect() {
        return new IntersectionDatasetCollector();
    }

    public static class IntersectionDatasetCollector
    extends DatasetCollector {
        private volatile boolean afterFirstElement = false;

        public BinaryOperator<Dataset> combiner() {
            return DatasetLib::intersection;
        }

        public BiConsumer<Dataset, Dataset> accumulator() {
            return (d1, d2) -> {
                if (this.afterFirstElement) {
                    d1.setDefaultModel(d1.getDefaultModel().intersection(d2.getDefaultModel()));
                    d1.listNames().forEachRemaining(name -> {
                        if (d2.containsNamedModel((String)name)) {
                            Model intersection = d1.getNamedModel((String)name).intersection(d2.getNamedModel((String)name));
                            d1.replaceNamedModel((String)name, intersection);
                        } else {
                            d1.removeNamedModel((String)name);
                        }
                    });
                } else {
                    d1.setDefaultModel(d2.getDefaultModel());
                    d2.listNames().forEachRemaining(name -> d1.replaceNamedModel((String)name, d2.getNamedModel((String)name)));
                    this.afterFirstElement = true;
                }
            };
        }
    }

    public static class UnionDatasetCollector
    extends DatasetCollector {
        public BinaryOperator<Dataset> combiner() {
            return DatasetLib::union;
        }

        public BiConsumer<Dataset, Dataset> accumulator() {
            return (d1, d2) -> {
                d1.getDefaultModel().add(d2.getDefaultModel());
                d2.listNames().forEachRemaining(name -> {
                    Model union = d1.getNamedModel((String)name).union(d2.getNamedModel((String)name));
                    d1.replaceNamedModel((String)name, union);
                });
            };
        }
    }

    public static class ConcurrentDatasetCollector
    extends DatasetCollector
    implements IdentityFinishCollector.ConcurrentUnorderedIdentityFinishCollector<Dataset, Dataset> {
        private final DatasetCollector collector;

        public ConcurrentDatasetCollector(DatasetCollector col) {
            this.collector = col;
        }

        public BinaryOperator<Dataset> combiner() {
            return (d1, d2) -> Txn.calculateRead(d2, () -> Txn.calculateWrite(d1, () -> (Dataset)this.collector.combiner().apply(d1, d2)));
        }

        public BiConsumer<Dataset, Dataset> accumulator() {
            return (d1, d2) -> Txn.executeRead(d2, () -> Txn.executeWrite(d1, () -> this.collector.accumulator().accept(d1, d2)));
        }
    }
}

