/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.engine.main.solver.PatternMatchData;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.mgt.Explain;

public class StageGeneratorGeneric
implements StageGenerator {
    private static final ReorderTransformation reorderFixed = ReorderLib.fixed();

    @Override
    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        if (input == null) {
            Log.error((Object)this, (String)("Null input to " + Lib.classShortName(this.getClass())));
        }
        ReorderTransformation reorder = reorderFixed;
        return this.execute(pattern, reorder, input, execCxt);
    }

    protected QueryIterator execute(BasicPattern pattern, ReorderTransformation reorder, QueryIterator input, ExecutionContext execCxt) {
        Explain.explain(pattern, execCxt.getContext());
        if (!input.hasNext()) {
            return input;
        }
        if (reorder != null && pattern.size() >= 2) {
            BasicPattern bgp2 = pattern;
            if (!input.isJoinIdentity()) {
                QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
                input = peek;
                Binding b = peek.peek();
                bgp2 = Substitute.substitute(pattern, b);
            }
            ReorderProc reorderProc = reorder.reorderIndexes(bgp2);
            pattern = reorderProc.reorder(pattern);
        }
        Explain.explain("Reorder/generic", pattern, execCxt.getContext());
        return PatternMatchData.execute(execCxt.getActiveGraph(), pattern, input, null, execCxt);
    }
}

