/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.PairOfSameType;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapUnmodifiable;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;

public abstract class DyadicDatasetGraph
extends PairOfSameType<DatasetGraph>
implements DatasetGraph {
    private Context context;
    private final Lock lock;

    protected DyadicDatasetGraph(DatasetGraph left, DatasetGraph right, Context c) {
        super((Object)Objects.requireNonNull(left), (Object)Objects.requireNonNull(right));
        this.context = Objects.requireNonNull(c);
        this.lock = new PairLock(left.getLock(), right.getLock());
    }

    protected static void throwNoMutationAllowed() {
        throw new UnsupportedOperationException("This view does not allow mutation!");
    }

    @Override
    public PrefixMap prefixes() {
        return new PrefixMapUnmodifiable(((DatasetGraph)this.getLeft()).prefixes());
    }

    @Override
    public void commit() {
        this.forEach(Transactional::commit);
    }

    @Override
    public void begin() {
        this.begin(TxnType.READ);
    }

    @Override
    public void begin(TxnType type) {
        switch (type) {
            case READ: {
                this.forEach(dsg -> dsg.begin(type));
                break;
            }
            default: {
                throw new JenaTransactionException("Only READ transactions supported");
            }
        }
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return false;
    }

    @Override
    public ReadWrite transactionMode() {
        if (!this.isInTransaction()) {
            return null;
        }
        return TxnType.convert(this.transactionType());
    }

    @Override
    public TxnType transactionType() {
        if (!this.isInTransaction()) {
            return null;
        }
        return TxnType.READ;
    }

    @Override
    public synchronized void begin(ReadWrite readWrite) {
        Objects.requireNonNull(readWrite);
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public void abort() {
        this.forEach(Transactional::abort);
    }

    @Override
    public void end() {
        this.forEach(Transactional::end);
    }

    @Override
    public boolean isInTransaction() {
        if (this.both(Transactional::isInTransaction)) {
            return true;
        }
        if (!this.either(Transactional::isInTransaction)) {
            return false;
        }
        throw new JenaTransactionException("One datset in a transaction and one not");
    }

    @Override
    public void setDefaultGraph(Graph g) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void removeGraph(Node graphName) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void add(Quad quad) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void delete(Quad quad) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public void clear() {
        DyadicDatasetGraph.throwNoMutationAllowed();
    }

    @Override
    public Iterator<Quad> find() {
        return this.find(Quad.ANY);
    }

    @Override
    public Iterator<Quad> find(Quad q) {
        return this.find(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        if (g.isConcrete()) {
            return this.findInOneGraph(g, s, p, o);
        }
        Iter iter = this.findNG(Node.ANY, s, p, o);
        iter = Iter.concat(iter, this.findInOneGraph(Quad.defaultGraphIRI, s, p, o));
        return iter;
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        if (g.isConcrete()) {
            return this.findInOneGraph(g, s, p, o);
        }
        Iterator iter = Iter.flatMap((Iterator)this.listGraphNodes(), gn -> this.findInOneGraph((Node)gn, s, p, o));
        return iter;
    }

    protected Iterator<Quad> findInOneGraph(Node g, Node s, Node p, Node o) {
        return G.triples2quads(g, (Iterator<Triple>)this.getGraph(g).find(s, p, o));
    }

    @Override
    public Graph getUnionGraph() {
        return new MultiUnion(Iter.map((Iterator)this.listGraphNodes(), this::getGraph));
    }

    @Override
    public boolean contains(Quad q) {
        return this.contains(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public DatasetGraph setContext(Context c) {
        this.context = c;
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportsTransactions() {
        return this.both(DatasetGraph::supportsTransactions);
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.both(DatasetGraph::supportsTransactionAbort);
    }

    @Override
    public long size() {
        return Iter.count((Iterator)this.listGraphNodes());
    }

    @Override
    public boolean isEmpty() {
        return this.listGraphNodes().hasNext();
    }

    private static class PairLock
    extends PairOfSameType<Lock>
    implements Lock {
        public PairLock(Lock left, Lock right) {
            super((Object)left, (Object)right);
        }

        public void enterCriticalSection(boolean readLockRequested) {
            this.forEach(lock -> lock.enterCriticalSection(readLockRequested));
        }

        public void leaveCriticalSection() {
            this.forEach(Lock::leaveCriticalSection);
        }
    }
}

