/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.ColumnMap;

public class Tuple<T>
implements Iterable<T> {
    protected final T[] tuple;

    public static <X> Tuple<X> createTuple(X ... elements) {
        X[] els = elements;
        return Tuple.create(els);
    }

    public static <X> Tuple<X> create(X[] elements) {
        return new Tuple<X>(elements);
    }

    public static <T> Iterator<T> project(int slot, Iterator<Tuple<T>> iter) {
        return Iter.map(iter, t -> t.get(slot));
    }

    public static <T> Iterator<Tuple<T>> prefix(int prefixLength, Iterator<Tuple<T>> iter) {
        Function<Tuple, Tuple> sub = t -> {
            T[] x = ArrayUtils.copy(t.tuple, 0, prefixLength);
            return Tuple.create(x);
        };
        return Iter.map(iter, sub);
    }

    protected Tuple(T ... tuple) {
        this.tuple = tuple;
    }

    public T get(int idx) {
        return this.tuple[idx];
    }

    public int countNotNull() {
        int x = 0;
        for (T item : this.tuple) {
            if (item == null) continue;
            ++x;
        }
        return x;
    }

    public List<T> asList() {
        return Arrays.asList(this.tuple);
    }

    public T[] tuple() {
        return this.tuple;
    }

    public T[] tupleCopy() {
        return ArrayUtils.copy(this.tuple);
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.tuple).iterator();
    }

    public Tuple<T> map(ColumnMap colMap) {
        return colMap.map(this);
    }

    public Tuple<T> unmap(ColumnMap colMap) {
        return colMap.unmap(this);
    }

    public int size() {
        return this.tuple.length;
    }

    public int hashCode() {
        int x = 99;
        for (T n : this.tuple) {
            if (n == null) continue;
            x = x << 1 ^ n.hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Tuple)) {
            return false;
        }
        Tuple x = (Tuple)other;
        if (x.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.tuple.length; ++i) {
            T obj1 = this.tuple[i];
            T obj2 = x.tuple[i];
            if (Objects.equals(obj1, obj2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[" + Iter.asString(this.iterator(), ", ") + "]";
    }
}

