/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import org.apache.jena.mem.BunchMap;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.shared.BrokenException;

public class HashedBunchMap
extends HashCommon<Object>
implements BunchMap {
    protected TripleBunch[] values;

    public HashedBunchMap() {
        super(10);
        this.values = new TripleBunch[this.capacity];
    }

    @Override
    protected Object[] newKeyArray(int size) {
        return new Object[size];
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public TripleBunch get(Object key) {
        int slot = this.findSlot(key);
        return slot < 0 ? this.values[~slot] : null;
    }

    @Override
    public void put(Object key, TripleBunch value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
        } else {
            this.keys[slot] = key;
            this.values[slot] = value;
            ++this.size;
            if (this.size == this.threshold) {
                this.grow();
            }
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        TripleBunch[] oldValues = this.values;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = this.newKeyArray(this.capacity);
        this.values = new TripleBunch[this.capacity];
        for (int i = 0; i < oldCapacity; ++i) {
            Object key = oldContents[i];
            if (key == null) continue;
            int j = this.findSlot(key);
            if (j < 0) {
                throw new BrokenException("oh dear, already have a slot for " + key + ", viz " + ~j);
            }
            this.keys[j] = key;
            this.values[j] = oldValues[i];
        }
    }

    @Override
    protected void removeAssociatedValues(int here) {
        this.values[here] = null;
    }

    @Override
    protected void moveAssociatedValues(int here, int scan) {
        this.values[here] = this.values[scan];
    }
}

