/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.OWLFBRuleReasoner;
import org.apache.jena.reasoner.rulesys.OWLMicroReasoner;
import org.apache.jena.reasoner.rulesys.OWLMiniReasoner;
import org.apache.jena.reasoner.rulesys.RDFSFBRuleReasoner;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.RulesetNotFoundException;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.util.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rule
implements ClauseEntry {
    protected ClauseEntry[] body;
    protected ClauseEntry[] head;
    protected String name;
    protected int numVars = -1;
    protected boolean isBackward = false;
    protected boolean isMonotonic = true;
    static Logger logger = LoggerFactory.getLogger(Rule.class);

    public Rule(List<ClauseEntry> head, List<ClauseEntry> body) {
        this(null, head, body);
    }

    public Rule(String name, List<ClauseEntry> head, List<ClauseEntry> body) {
        this(name, head.toArray(new ClauseEntry[head.size()]), body.toArray(new ClauseEntry[body.size()]));
    }

    public Rule(String name, ClauseEntry[] head, ClauseEntry[] body) {
        this.name = name;
        this.head = head;
        this.body = body;
        this.isMonotonic = this.allMonotonic(head);
    }

    private boolean allMonotonic(ClauseEntry[] elts) {
        for (ClauseEntry elt : elts) {
            if (!(elt instanceof Functor)) continue;
            Builtin b = ((Functor)elt).getImplementor();
            if (b != null) {
                if (b.isMonotonic()) continue;
                return false;
            }
            throw new ReasonerException("Undefined Functor " + ((Functor)elt).getName() + " in " + this.toShortString());
        }
        return true;
    }

    public int bodyLength() {
        return this.body.length;
    }

    public ClauseEntry getBodyElement(int n) {
        return this.body[n];
    }

    public ClauseEntry[] getBody() {
        return this.body;
    }

    public int headLength() {
        return this.head.length;
    }

    public ClauseEntry getHeadElement(int n) {
        return this.head[n];
    }

    public ClauseEntry[] getHead() {
        return this.head;
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public void setBackward(boolean flag) {
        this.isBackward = flag;
    }

    public String getName() {
        return this.name;
    }

    public void setNumVars(int n) {
        this.numVars = n;
    }

    public int getNumVars() {
        if (this.numVars == -1) {
            int max = this.findVars(this.body, -1);
            max = this.findVars(this.head, max);
            this.numVars = max + 1;
        }
        return this.numVars;
    }

    private int findVars(Object[] nodes, int maxIn) {
        int max = maxIn;
        for (Object node : nodes) {
            max = node instanceof TriplePattern ? this.findVars((TriplePattern)node, max) : this.findVars((Functor)node, max);
        }
        return max;
    }

    private int findVars(TriplePattern t, int maxIn) {
        int max = maxIn;
        max = this.maxVarIndex(t.getSubject(), max);
        max = this.maxVarIndex(t.getPredicate(), max);
        Node obj = t.getObject();
        if (obj instanceof Node_RuleVariable) {
            max = this.maxVarIndex(obj, max);
        } else if (Functor.isFunctor(obj)) {
            max = this.findVars((Functor)obj.getLiteralValue(), max);
        }
        return max;
    }

    private int findVars(Functor f, int maxIn) {
        Node[] args;
        int max = maxIn;
        for (Node arg : args = f.getArgs()) {
            if (!arg.isVariable()) continue;
            max = this.maxVarIndex(arg, max);
        }
        return max;
    }

    private int maxVarIndex(Node var, int max) {
        int index;
        if (var instanceof Node_RuleVariable && (index = ((Node_RuleVariable)var).index) > max) {
            return index;
        }
        return max;
    }

    public Rule instantiate(BindingEnvironment env) {
        HashMap<Node_RuleVariable, Node> vmap = new HashMap<Node_RuleVariable, Node>();
        return new Rule(this.name, this.cloneClauseArray(this.head, vmap, env), this.cloneClauseArray(this.body, vmap, env));
    }

    public Rule cloneRule() {
        if (this.getNumVars() > 0) {
            HashMap<Node_RuleVariable, Node> vmap = new HashMap<Node_RuleVariable, Node>();
            return new Rule(this.name, this.cloneClauseArray(this.head, vmap, null), this.cloneClauseArray(this.body, vmap, null));
        }
        return this;
    }

    private ClauseEntry[] cloneClauseArray(ClauseEntry[] clauses, Map<Node_RuleVariable, Node> vmap, BindingEnvironment env) {
        ClauseEntry[] cClauses = new ClauseEntry[clauses.length];
        for (int i = 0; i < clauses.length; ++i) {
            cClauses[i] = this.cloneClause(clauses[i], vmap, env);
        }
        return cClauses;
    }

    private ClauseEntry cloneClause(ClauseEntry clause, Map<Node_RuleVariable, Node> vmap, BindingEnvironment env) {
        if (clause instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)clause;
            return new TriplePattern(this.cloneNode(tp.getSubject(), vmap, env), this.cloneNode(tp.getPredicate(), vmap, env), this.cloneNode(tp.getObject(), vmap, env));
        }
        return this.cloneFunctor((Functor)clause, vmap, env);
    }

    private Functor cloneFunctor(Functor f, Map<Node_RuleVariable, Node> vmap, BindingEnvironment env) {
        Node[] args = f.getArgs();
        Node[] cargs = new Node[args.length];
        for (int i = 0; i < args.length; ++i) {
            cargs[i] = this.cloneNode(args[i], vmap, env);
        }
        Functor fn = new Functor(f.getName(), cargs);
        fn.setImplementor(f.getImplementor());
        return fn;
    }

    private Node cloneNode(Node nIn, Map<Node_RuleVariable, Node> vmap, BindingEnvironment env) {
        Node n;
        Node node = n = env == null ? nIn : env.getGroundVersion(nIn);
        if (n instanceof Node_RuleVariable) {
            Node_RuleVariable nv = (Node_RuleVariable)n;
            Node c = vmap.get(nv);
            if (c == null) {
                c = ((Node_RuleVariable)n).cloneNode();
                vmap.put(nv, c);
            }
            return c;
        }
        if (Functor.isFunctor(n)) {
            Functor f = (Functor)n.getLiteralValue();
            return Functor.makeFunctorNode(this.cloneFunctor(f, vmap, env));
        }
        return n;
    }

    public boolean isMonotonic() {
        return this.isMonotonic;
    }

    public boolean isAxiom() {
        if (this.isBackward() && this.body.length > 0) {
            return false;
        }
        for (ClauseEntry aBody : this.body) {
            if (!(aBody instanceof TriplePattern)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("[ ");
        if (this.name != null) {
            buff.append(this.name);
            buff.append(": ");
        }
        if (this.isBackward) {
            for (ClauseEntry aHead : this.head) {
                buff.append(PrintUtil.print(aHead));
                buff.append(" ");
            }
            buff.append("<- ");
            for (ClauseEntry aBody : this.body) {
                buff.append(PrintUtil.print(aBody));
                buff.append(" ");
            }
        } else {
            for (ClauseEntry aBody : this.body) {
                buff.append(PrintUtil.print(aBody));
                buff.append(" ");
            }
            buff.append("-> ");
            for (ClauseEntry aHead : this.head) {
                buff.append(PrintUtil.print(aHead));
                buff.append(" ");
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public String toShortString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public static Rule parseRule(String source) throws ParserException {
        Parser parser = new Parser(source);
        return parser.parseRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Rule> rulesFromURL(String uri) {
        BufferedReader br = null;
        try {
            InputStream in = FileManager.get().open(uri);
            if (in == null) {
                throw new RulesetNotFoundException(uri);
            }
            br = FileUtils.asBufferedUTF8(in);
            List<Rule> list = Rule.parseRules(Rule.rulesParserFromReader(br));
            return list;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Parser rulesParserFromReader(BufferedReader src) {
        try {
            String line;
            StringBuilder result = new StringBuilder();
            HashMap<String, String> prefixes = new HashMap<String, String>();
            ArrayList<Rule> preloadedRules = new ArrayList<Rule>();
            while ((line = src.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).startsWith("//")) continue;
                if (line.startsWith("@prefix")) {
                    line = line.substring("@prefix".length());
                    String prefix = Rule.nextArg(line);
                    String rest = Rule.nextAfterArg(line);
                    if (prefix.endsWith(":")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    String url = Rule.extractURI(rest);
                    prefixes.put(prefix, url);
                    continue;
                }
                if (line.startsWith("@include")) {
                    String url = Rule.extractURI(line = line.substring("@include".length()));
                    if (url.equalsIgnoreCase("rdfs")) {
                        preloadedRules.addAll(RDFSFBRuleReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owl")) {
                        preloadedRules.addAll(OWLFBRuleReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owlmicro")) {
                        preloadedRules.addAll(OWLMicroReasoner.loadRules());
                        continue;
                    }
                    if (url.equalsIgnoreCase("owlmini")) {
                        preloadedRules.addAll(OWLMiniReasoner.loadRules());
                        continue;
                    }
                    preloadedRules.addAll(Rule.rulesFromURL(url));
                    continue;
                }
                result.append(line);
                result.append("\n");
            }
            Parser parser = new Parser(result.toString());
            parser.registerPrefixMap(prefixes);
            parser.addRulesPreload(preloadedRules);
            return parser;
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private static String extractURI(String lineSoFar) {
        String token = lineSoFar.trim();
        if (token.startsWith("<")) {
            int split = token.indexOf(62);
            token = token.substring(1, split);
        }
        return token;
    }

    private static String nextArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        return token.substring(start, stop);
    }

    private static String nextAfterArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        int rest = Rule.nextSplit(stop, false, token);
        return token.substring(rest);
    }

    private static int nextSplit(int start, boolean white, String line) {
        int i;
        for (i = start; i < line.length(); ++i) {
            boolean isWhite = Character.isWhitespace(line.charAt(i));
            if (!(white & isWhite) && !(!white & !isWhite)) continue;
            return i;
        }
        return i;
    }

    public static List<Rule> parseRules(Parser parser) throws ParserException {
        boolean finished = false;
        ArrayList<Rule> ruleset = new ArrayList<Rule>();
        ruleset.addAll(parser.getRulesPreload());
        while (!finished) {
            try {
                parser.peekToken();
            }
            catch (NoSuchElementException e) {
                finished = true;
                break;
            }
            Rule rule = parser.parseRule();
            ruleset.add(rule);
        }
        return ruleset;
    }

    public static List<Rule> parseRules(String source) throws ParserException {
        return Rule.parseRules(new Parser(source));
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (other.head.length != this.head.length) {
            return false;
        }
        if (other.body.length != this.body.length) {
            return false;
        }
        for (i = 0; i < this.body.length; ++i) {
            if (this.body[i].sameAs(other.body[i])) continue;
            return false;
        }
        for (i = 0; i < this.head.length; ++i) {
            if (this.head[i].sameAs(other.head[i])) continue;
            return false;
        }
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }

    public int hashCode() {
        int hash = 0;
        for (ClauseEntry aBody : this.body) {
            hash = hash << 1 ^ aBody.hashCode();
        }
        for (ClauseEntry aHead : this.head) {
            hash = hash << 1 ^ aHead.hashCode();
        }
        return hash;
    }

    @Override
    public boolean sameAs(Object o) {
        return this.equals(o);
    }

    public static class ParserException
    extends JenaException {
        public ParserException(String message, Parser parser) {
            super(ParserException.constructMessage(message, parser));
        }

        private static String constructMessage(String baseMessage, Parser parser) {
            StringBuilder message = new StringBuilder();
            message.append(baseMessage);
            message.append("\nAt '");
            message.append(parser.recentTokens());
            message.append("'");
            return message.toString();
        }
    }

    public static class Parser {
        private Tokenizer stream;
        private String lookahead;
        private static final int NORMAL = 0;
        private static final int STARTED_LITERAL = 1;
        private int literalState = 0;
        protected List<String> priorTokens = new ArrayList<String>();
        private static final int maxPriors = 20;
        private Map<String, Node_RuleVariable> varMap;
        private PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        private List<Rule> preloadedRules = new ArrayList<Rule>();

        Parser(String source) {
            this.stream = new Tokenizer(source, "()[], \t\n\r", "'\"", true);
            this.lookahead = null;
        }

        public void registerPrefix(String prefix, String namespace) {
            this.prefixMapping.setNsPrefix(prefix, namespace);
        }

        public void registerPrefixMap(Map<String, String> map) {
            this.prefixMapping.setNsPrefixes(map);
        }

        public Map<String, String> getPrefixMap() {
            return this.prefixMapping.getNsPrefixMap();
        }

        void addRulesPreload(List<Rule> rules) {
            this.preloadedRules.addAll(rules);
        }

        public List<Rule> getRulesPreload() {
            return this.preloadedRules;
        }

        String nextToken() {
            if (this.lookahead != null) {
                String temp = this.lookahead;
                this.lookahead = null;
                return temp;
            }
            String token = this.stream.nextToken();
            if (this.literalState == 0) {
                while (this.isSeparator(token)) {
                    token = this.stream.nextToken();
                }
            }
            if (token.equals("'")) {
                this.literalState = this.literalState == 0 ? 1 : 0;
            }
            this.priorTokens.add(0, token);
            if (this.priorTokens.size() > 20) {
                this.priorTokens.remove(this.priorTokens.size() - 1);
            }
            return token;
        }

        public String recentTokens() {
            StringBuilder trace = new StringBuilder();
            for (int i = this.priorTokens.size() - 1; i >= 0; --i) {
                trace.append(this.priorTokens.get(i));
                trace.append(" ");
            }
            return trace.toString();
        }

        String peekToken() {
            if (this.lookahead == null) {
                this.lookahead = this.nextToken();
            }
            return this.lookahead;
        }

        void pushback(String token) {
            this.lookahead = token;
        }

        boolean isSeparator(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == ',' || Character.isWhitespace(c);
            }
            return false;
        }

        boolean isSyntax(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == '(' || c == ')' || c == '[' || c == ']';
            }
            return false;
        }

        Node_RuleVariable getNodeVar(String name) {
            Node_RuleVariable node = this.varMap.get(name);
            if (node == null) {
                node = new Node_RuleVariable(name, this.varMap.size());
                this.varMap.put(name, node);
            }
            return node;
        }

        Node parseNode(String token) {
            if (token.startsWith("?")) {
                return this.getNodeVar(token);
            }
            if (token.equals("*") || token.equals("_")) {
                throw new ParserException("Wildcard variables no longer supported", this);
            }
            if (token.startsWith("<") && token.endsWith(">")) {
                String uri = token.substring(1, token.length() - 1);
                return NodeFactory.createURI(uri);
            }
            if (token.startsWith("_")) {
                return NodeFactory.createBlankNode(token.substring(1));
            }
            if (token.indexOf(58) != -1) {
                String prefix;
                String exp = this.prefixMapping.expandPrefix(token);
                if (!((exp = PrintUtil.expandQname(exp)) != token || (prefix = token.substring(0, token.indexOf(58))).equals("http") || prefix.equals("urn") || prefix.equals("file") || prefix.equals("ftp") || prefix.equals("mailto"))) {
                    throw new ParserException("Unrecognized qname prefix (" + prefix + ") in rule", this);
                }
                return NodeFactory.createURI(exp);
            }
            if (this.peekToken().equals("(")) {
                Functor f = new Functor(token, this.parseNodeList(), BuiltinRegistry.theRegistry);
                return Functor.makeFunctorNode(f);
            }
            if (token.equals("'") || token.equals("\"")) {
                String lit = this.nextToken();
                this.nextToken();
                if (this.peekToken().startsWith("^^")) {
                    String dtURI = this.nextToken().substring(2);
                    if (dtURI.indexOf(58) != -1) {
                        String exp = this.prefixMapping.expandPrefix(dtURI);
                        if ((exp = PrintUtil.expandQname(exp)) == dtURI) {
                            String prefix = dtURI.substring(0, dtURI.indexOf(58));
                            if (!(prefix.equals("http") || prefix.equals("urn") || prefix.equals("ftp") || prefix.equals("mailto"))) {
                                throw new ParserException("Unrecognized qname prefix (" + prefix + ") in rule", this);
                            }
                        } else {
                            dtURI = exp;
                        }
                    }
                    RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
                    return NodeFactory.createLiteral(lit, dt);
                }
                return NodeFactory.createLiteral(lit, "");
            }
            if (Character.isDigit(token.charAt(0)) || token.charAt(0) == '-' && token.length() > 1 && Character.isDigit(token.charAt(1))) {
                return this.parseNumber(token);
            }
            return NodeFactory.createURI(token);
        }

        Node parseNumber(String lit) {
            if (Character.isDigit(lit.charAt(0)) || lit.charAt(0) == '-' && lit.length() > 1 && Character.isDigit(lit.charAt(1))) {
                if (lit.contains(".")) {
                    if (XSDDatatype.XSDfloat.isValid(lit)) {
                        return NodeFactory.createLiteral(lit, XSDDatatype.XSDfloat);
                    }
                } else if (XSDDatatype.XSDint.isValid(lit)) {
                    return NodeFactory.createLiteral(lit, XSDDatatype.XSDint);
                }
            }
            return NodeFactory.createLiteral(lit, "");
        }

        List<Node> parseNodeList() {
            String token = this.nextToken();
            if (!token.equals("(")) {
                throw new ParserException("Expected '(' at start of clause, found " + token, this);
            }
            token = this.nextToken();
            ArrayList<Node> nodeList = new ArrayList<Node>();
            while (!this.isSyntax(token)) {
                nodeList.add(this.parseNode(token));
                token = this.nextToken();
            }
            if (!token.equals(")")) {
                throw new ParserException("Expected ')' at end of clause, found " + token, this);
            }
            return nodeList;
        }

        ClauseEntry parseClause() {
            List<Node> args;
            String token = this.peekToken();
            if (token.equals("(")) {
                List<Node> nodes = this.parseNodeList();
                if (nodes.size() != 3) {
                    throw new ParserException("Triple with " + nodes.size() + " nodes!", this);
                }
                if (Functor.isFunctor(nodes.get(0))) {
                    throw new ParserException("Functors not allowed in subject position of pattern", this);
                }
                if (Functor.isFunctor(nodes.get(1))) {
                    throw new ParserException("Functors not allowed in predicate position of pattern", this);
                }
                return new TriplePattern(nodes.get(0), nodes.get(1), nodes.get(2));
            }
            if (token.equals("[")) {
                this.nextToken();
                return this.doParseRule(true);
            }
            String name = this.nextToken();
            Functor clause = new Functor(name, args = this.parseNodeList(), BuiltinRegistry.theRegistry);
            if (clause.getImplementor() == null) {
                logger.warn("Rule references unimplemented functor: " + name);
            }
            return clause;
        }

        public Rule parseRule() {
            return this.doParseRule(false);
        }

        private Rule doParseRule(boolean retainVarMap) {
            try {
                if (this.peekToken().equals("[")) {
                    this.nextToken();
                }
                String name = null;
                String token = this.peekToken();
                if (token.endsWith(":")) {
                    name = token.substring(0, token.length() - 1);
                    this.nextToken();
                }
                if (!retainVarMap) {
                    this.varMap = new HashMap<String, Node_RuleVariable>();
                }
                ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
                token = this.peekToken();
                while (!token.equals("->") && !token.equals("<-")) {
                    body.add(this.parseClause());
                    token = this.peekToken();
                }
                boolean backwardRule = token.equals("<-");
                ArrayList<ClauseEntry> head = new ArrayList<ClauseEntry>();
                token = this.nextToken();
                token = this.peekToken();
                while (!token.equals(".") && !token.equals("]")) {
                    head.add(this.parseClause());
                    token = this.peekToken();
                }
                this.nextToken();
                Rule r = null;
                r = backwardRule ? new Rule(name, body, head) : new Rule(name, head, body);
                r.numVars = this.varMap.keySet().size();
                r.isBackward = backwardRule;
                return r;
            }
            catch (NoSuchElementException e) {
                throw new ParserException("Malformed rule", this);
            }
        }
    }
}

