/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import org.apache.jena.rdf.model.impl.Util;

public class SplitIRI {
    public static String namespace(String string) {
        int i = SplitIRI.splitpoint(string);
        if (i < 0) {
            return string;
        }
        return string.substring(0, i);
    }

    public static String localname(String string) {
        int i = SplitIRI.splitpoint(string);
        if (i < 0) {
            return "";
        }
        return string.substring(i);
    }

    public static String namespaceTTL(String string) {
        return SplitIRI.namespaceTTL(string);
    }

    public static String localnameTTL(String string) {
        String x = SplitIRI.localname(string);
        if (x.isEmpty()) {
            return x;
        }
        return SplitIRI.escape_PN_LOCAL_ESC(x);
    }

    private static String escape_PN_LOCAL_ESC(String x) {
        int N = x.length();
        boolean escchar = false;
        for (int i = 0; i < N; ++i) {
            char ch = x.charAt(i);
            if (!SplitIRI.needsEscape(ch, i == N - 1)) continue;
            escchar = true;
            break;
        }
        if (!escchar) {
            return x;
        }
        StringBuilder sb = new StringBuilder(N + 10);
        for (int i = 0; i < N; ++i) {
            char ch = x.charAt(i);
            if (SplitIRI.needsEscape(ch, i == N - 1)) {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean needsEscape(char ch, boolean finalChar) {
        if (ch == '.') {
            return finalChar;
        }
        return SplitIRI.isPN_LOCAL_ESC(ch);
    }

    public static boolean isPN_LOCAL_ESC(char ch) {
        switch (ch) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '\\': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static int splitpoint(String uri) {
        boolean isURN = uri.startsWith("urn:");
        int idx1 = uri.lastIndexOf(35);
        int idx2 = isURN ? uri.lastIndexOf(58) : uri.lastIndexOf(47);
        int idx3 = uri.indexOf(58);
        if (uri.endsWith(".")) {
            // empty if block
        }
        int limit = Math.max(idx1, idx2);
        limit = Math.max(limit, idx3);
        limit = Math.max(-1, limit);
        int splitPoint = -1;
        for (int i = uri.length() - 1; i > limit; --i) {
            char ch = uri.charAt(i);
            if (SplitIRI.isPNChars_U_N(ch) || SplitIRI.isPN_LOCAL_ESC(ch) || ch == ':' || ch == '-' || ch == '.') continue;
            splitPoint = i + 1;
            break;
        }
        if (splitPoint == -1) {
            splitPoint = limit + 1;
        }
        if (splitPoint >= uri.length()) {
            return -1;
        }
        char ch = uri.charAt(splitPoint);
        while (ch == '.' || ch == '-') {
            if (++splitPoint >= uri.length()) {
                return -1;
            }
            ch = uri.charAt(splitPoint);
        }
        return splitPoint;
    }

    private static boolean checkhex(String uri, int i) {
        return SplitIRI.isHexChar(uri.charAt(i));
    }

    public static int splitXML(String string) {
        return Util.splitNamespaceXML(string);
    }

    public static String namespaceXML(String string) {
        int i = SplitIRI.splitXML(string);
        return string.substring(0, i);
    }

    public static String localnameXML(String string) {
        int i = SplitIRI.splitXML(string);
        return string.substring(i);
    }

    private static boolean isDigit(int ch) {
        return SplitIRI.range(ch, '0', '9');
    }

    private static boolean isPNCharsBase(int ch) {
        return SplitIRI.r(ch, 97, 122) || SplitIRI.r(ch, 65, 90) || SplitIRI.r(ch, 192, 214) || SplitIRI.r(ch, 216, 246) || SplitIRI.r(ch, 248, 767) || SplitIRI.r(ch, 880, 893) || SplitIRI.r(ch, 895, 8191) || SplitIRI.r(ch, 8204, 8205) || SplitIRI.r(ch, 8304, 8591) || SplitIRI.r(ch, 11264, 12271) || SplitIRI.r(ch, 12289, 55295) || SplitIRI.r(ch, 55296, 57343) || SplitIRI.r(ch, 63744, 64975) || SplitIRI.r(ch, 65008, 65533) || SplitIRI.r(ch, 65536, 983039);
    }

    private static boolean isPNChars_U(int ch) {
        return SplitIRI.isPNCharsBase(ch) || ch == 95;
    }

    private static boolean isPNChars_U_N(int ch) {
        return SplitIRI.isPNCharsBase(ch) || ch == 95 || SplitIRI.isDigit(ch);
    }

    private static boolean isPNChars(int ch) {
        return SplitIRI.isPNChars_U(ch) || SplitIRI.isDigit(ch) || ch == 45 || ch == 183 || SplitIRI.r(ch, 768, 879) || SplitIRI.r(ch, 8255, 8256);
    }

    private static boolean isHexChar(int ch) {
        return SplitIRI.range(ch, '0', '9') || SplitIRI.range(ch, 'a', 'f') || SplitIRI.range(ch, 'A', 'F');
    }

    private static int valHexChar(int ch) {
        if (SplitIRI.range(ch, '0', '9')) {
            return ch - 48;
        }
        if (SplitIRI.range(ch, 'a', 'f')) {
            return ch - 97 + 10;
        }
        if (SplitIRI.range(ch, 'A', 'F')) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private static boolean r(int ch, int a, int b) {
        return ch >= a && ch <= b;
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }
}

