/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DatatypeException
extends Exception {
    static final long serialVersionUID = 1940805832730465578L;
    protected final String key;
    protected final Object[] args;

    public DatatypeException(String key, Object[] args) {
        super(key);
        this.key = key;
        this.args = args;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public String getMessage() {
        ResourceBundle resourceBundle = null;
        resourceBundle = ResourceBundle.getBundle("org.apache.jena.ext.xerces.impl.msg.XMLSchemaMessages");
        if (resourceBundle == null) {
            throw new MissingResourceException("Property file not found!", "org.apache.jena.ext.xerces.impl.msg.XMLSchemaMessages", this.key);
        }
        Object msg = resourceBundle.getString(this.key);
        if (msg == null) {
            msg = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException((String)msg, "org.apache.jena.ext.xerces.impl.msg.XMLSchemaMessages", this.key);
        }
        if (this.args != null) {
            try {
                msg = MessageFormat.format((String)msg, this.args);
            }
            catch (Exception e) {
                msg = resourceBundle.getString("FormatFailed");
                msg = (String)msg + " " + resourceBundle.getString(this.key);
            }
        }
        return msg;
    }
}

