/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.RandomOrderIterator;

public class RandomOrderGraph
extends WrappedGraph {
    private final int bufsz;

    public static Graph createDefaultGraph() {
        return new RandomOrderGraph(GraphMemFactory.createDefaultGraph());
    }

    public static Model createDefaultModel() {
        return ModelFactory.createModelForGraph(RandomOrderGraph.createDefaultGraph());
    }

    public RandomOrderGraph(int bufsz, Graph base) {
        super(base);
        this.bufsz = bufsz;
    }

    public RandomOrderGraph(Graph base) {
        this(10, base);
    }

    @Override
    public ExtendedIterator<Triple> find(Triple triple) {
        return new RandomOrderIterator<Triple>(this.bufsz, (Iterator<Triple>)((Object)super.find(triple)));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return new RandomOrderIterator<Triple>(this.bufsz, (Iterator<Triple>)((Object)super.find(s, p, o)));
    }
}

