/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.IOException;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.JSR223TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSR223Assertion
extends JSR223TestElement
implements Cloneable,
Assertion,
TestBean {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 234L;

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        try {
            ScriptEngineManager mgr = this.getManager();
            if (mgr == null) {
                result.setFailure(true);
                result.setError(true);
                result.setFailureMessage("JSR223 Manager not found");
                return result;
            }
            mgr.put("SampleResult", response);
            mgr.put("AssertionResult", result);
            this.processFileOrScript(mgr);
            result.setError(false);
        }
        catch (IOException e) {
            log.warn("Problem in JSR223 script " + e);
            result.setError(true);
            result.setFailureMessage(e.toString());
        }
        catch (ScriptException e) {
            log.warn("Problem in JSR223 script " + e);
            result.setError(true);
            result.setFailureMessage(e.toString());
        }
        return result;
    }
}

