/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class InterleaveControl
extends GenericController
implements Serializable {
    private static final long serialVersionUID = 233L;
    private static final String STYLE = "InterleaveControl.style";
    public static final int IGNORE_SUB_CONTROLLERS = 0;
    public static final int USE_SUB_CONTROLLERS = 1;
    private boolean skipNext;
    private transient TestElement searchStart = null;
    private boolean currentReturnedAtLeastOne;
    private boolean stillSame = true;

    public void reInitialize() {
        this.setFirst(true);
        this.currentReturnedAtLeastOne = false;
        this.searchStart = null;
        this.stillSame = true;
        this.skipNext = false;
        this.incrementIterCount();
        this.recoverRunningVersion();
    }

    public void setStyle(int style) {
        this.setProperty((JMeterProperty)new IntegerProperty(STYLE, style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public Sampler next() {
        if (this.isSkipNext()) {
            this.reInitialize();
            return null;
        }
        return super.next();
    }

    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            return this.next();
        }
        this.currentReturnedAtLeastOne = true;
        if (this.getStyle() == 0) {
            this.incrementCurrent();
            this.skipNext = true;
        } else {
            this.searchStart = null;
        }
        return sampler;
    }

    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.skipNext = true;
        this.incrementCurrent();
        return element;
    }

    protected Sampler nextIsNull() {
        this.resetCurrent();
        return this.next();
    }

    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
        if (this.searchStart == null) {
            this.searchStart = currentElement;
        } else if (this.searchStart == currentElement && !this.stillSame) {
            this.reInitialize();
            throw new NextIsNullException();
        }
    }

    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else if (this.getStyle() == 1) {
            this.incrementCurrent();
        }
    }

    protected boolean isSkipNext() {
        return this.skipNext;
    }

    protected void setSkipNext(boolean skipNext) {
        this.skipNext = skipNext;
    }

    protected void incrementCurrent() {
        if (this.currentReturnedAtLeastOne) {
            this.skipNext = true;
        }
        this.stillSame = false;
        super.incrementCurrent();
    }
}

