/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.timers.RandomTimer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public abstract class AbstractRandomTimerGui
extends AbstractTimerGui {
    private static final long serialVersionUID = -322164502276145504L;
    private static final String DELAY_FIELD = "Delay Field";
    private static final String RANGE_FIELD = "Range Field";
    private JTextField delayField;
    private JTextField rangeField;

    public AbstractRandomTimerGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public TestElement createTestElement() {
        RandomTimer timer = this.createRandomTimer();
        this.modifyTestElement((TestElement)timer);
        return timer;
    }

    public void modifyTestElement(TestElement timer) {
        this.configureTestElement(timer);
        ((RandomTimer)timer).setDelay(this.delayField.getText());
        ((RandomTimer)timer).setRange(this.rangeField.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.delayField.setText(el.getPropertyAsString("ConstantTimer.delay"));
        this.rangeField.setText(el.getPropertyAsString("RandomTimer.range"));
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel threadDelayPropsPanel = new JPanel();
        threadDelayPropsPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        threadDelayPropsPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"thread_delay_properties")));
        Box delayDevPanel = Box.createHorizontalBox();
        delayDevPanel.add(new JLabel(this.getTimerRangeLabelKey()));
        delayDevPanel.add(Box.createHorizontalStrut(5));
        this.rangeField = new JTextField(6);
        this.rangeField.setText(this.getDefaultRange());
        this.rangeField.setName(RANGE_FIELD);
        delayDevPanel.add(this.rangeField);
        threadDelayPropsPanel.add(delayDevPanel);
        Box avgDelayPanel = Box.createHorizontalBox();
        avgDelayPanel.add(new JLabel(this.getTimerDelayLabelKey()));
        avgDelayPanel.add(Box.createHorizontalStrut(5));
        this.delayField = new JTextField(6);
        this.delayField.setText(this.getDefaultDelay());
        this.delayField.setName(DELAY_FIELD);
        avgDelayPanel.add(this.delayField);
        threadDelayPropsPanel.add(avgDelayPanel);
        threadDelayPropsPanel.setMaximumSize(new Dimension(threadDelayPropsPanel.getMaximumSize().width, threadDelayPropsPanel.getPreferredSize().height));
        this.add(threadDelayPropsPanel);
        new FocusRequester((Component)this.rangeField);
    }

    public void clearGui() {
        this.rangeField.setText(this.getDefaultRange());
        this.delayField.setText(this.getDefaultDelay());
        super.clearGui();
    }

    public abstract String getLabelResource();

    protected abstract RandomTimer createRandomTimer();

    protected abstract String getTimerDelayLabelKey();

    protected abstract String getTimerRangeLabelKey();

    protected abstract String getDefaultDelay();

    protected abstract String getDefaultRange();
}

