/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.CompareAssertionResult;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.TreeNodeRenderer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

public class ComparisonVisualizer
extends AbstractVisualizer
implements Clearable {
    private static final long serialVersionUID = 240L;
    private JTree resultsTree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JTextPane base;
    private JTextPane secondary;

    public ComparisonVisualizer() {
        this.init();
    }

    public void add(SampleResult sample) {
        DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(sample);
        this.treeModel.insertNodeInto(currNode, this.root, this.root.getChildCount());
        if (this.root.getChildCount() == 1) {
            this.resultsTree.expandPath(new TreePath(this.root));
        }
    }

    public String getLabelResource() {
        return "comparison_visualizer_title";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JSplitPane split = new JSplitPane(1);
        split.add(this.getTreePanel());
        split.add(this.getSideBySidePanel());
        this.add(split, "Center");
    }

    private JComponent getSideBySidePanel() {
        JPanel main = new JPanel(new GridLayout(1, 2));
        JScrollPane base = new JScrollPane(this.getBaseTextPane());
        base.setPreferredSize(base.getMinimumSize());
        JScrollPane secondary = new JScrollPane(this.getSecondaryTextPane());
        secondary.setPreferredSize(secondary.getMinimumSize());
        main.add(base);
        main.add(secondary);
        main.setPreferredSize(main.getMinimumSize());
        return main;
    }

    private JTextPane getBaseTextPane() {
        this.base = new JTextPane();
        this.base.setEditable(false);
        this.base.setBackground(this.getBackground());
        return this.base;
    }

    private JTextPane getSecondaryTextPane() {
        this.secondary = new JTextPane();
        this.secondary.setEditable(false);
        return this.secondary;
    }

    private JComponent getTreePanel() {
        this.root = new DefaultMutableTreeNode("Root");
        this.treeModel = new DefaultTreeModel(this.root);
        this.resultsTree = new JTree(this.treeModel);
        this.resultsTree.setCellRenderer(new TreeNodeRenderer());
        this.resultsTree.setCellRenderer(new TreeNodeRenderer());
        this.resultsTree.getSelectionModel().setSelectionMode(1);
        this.resultsTree.addTreeSelectionListener(new Selector());
        this.resultsTree.setRootVisible(false);
        this.resultsTree.setShowsRootHandles(true);
        JScrollPane treePane = new JScrollPane(this.resultsTree);
        treePane.setPreferredSize(new Dimension(150, 50));
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(treePane);
        return panel;
    }

    public void clearData() {
        while (this.root.getChildCount() > 0) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(0));
            this.base.setText("");
            this.secondary.setText("");
        }
    }

    private class Selector
    implements TreeSelectionListener {
        private Selector() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ComparisonVisualizer.this.resultsTree.getLastSelectedPathComponent();
                SampleResult sr = (SampleResult)node.getUserObject();
                AssertionResult[] results = sr.getAssertionResults();
                CompareAssertionResult result = null;
                for (AssertionResult r : results) {
                    if (!(r instanceof CompareAssertionResult)) continue;
                    result = (CompareAssertionResult)r;
                    break;
                }
                if (result == null) {
                    result = new CompareAssertionResult(ComparisonVisualizer.this.getName());
                }
                ComparisonVisualizer.this.base.setText(result.getBaseResult());
                ComparisonVisualizer.this.secondary.setText(result.getSecondaryResult());
            }
            catch (Exception err) {
                ComparisonVisualizer.this.base.setText(JMeterUtils.getResString((String)"comparison_invalid_node") + err);
                ComparisonVisualizer.this.secondary.setText(JMeterUtils.getResString((String)"comparison_invalid_node") + err);
            }
            ComparisonVisualizer.this.base.setCaretPosition(0);
            ComparisonVisualizer.this.secondary.setCaretPosition(0);
        }
    }
}

