/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyControlGui
extends AbstractConfigGui
implements ActionListener,
UnsharedComponent {
    private static final long serialVersionUID = 1L;
    private static final String COLUMN_NAMES_0 = "name";
    private static final String COLUMN_NAMES_1 = "value";
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String SYSTEM = "system";
    private static final String JMETER = "jmeter";
    private JCheckBox systemButton = new JCheckBox("System");
    private JCheckBox jmeterButton = new JCheckBox("JMeter");
    private JLabel tableLabel = new JLabel("Properties");
    private transient JTable table;
    protected transient ObjectTableModel tableModel;

    public PropertyControlGui() {
        this.init();
    }

    public String getLabelResource() {
        return "property_visualiser_title";
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (ADD.equals(command)) {
            return;
        }
        if (DELETE.equals(command)) {
            return;
        }
        if (SYSTEM.equals(command)) {
            this.setUpData();
            return;
        }
        if (JMETER.equals(command)) {
            this.setUpData();
            return;
        }
    }

    public void add(SampleResult sample) {
    }

    public TestElement createTestElement() {
        ConfigTestElement el = new ConfigTestElement();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.setUpData();
    }

    private void setUpData() {
        this.tableModel.clearData();
        Properties p = null;
        if (this.systemButton.isSelected()) {
            p = System.getProperties();
        }
        if (this.jmeterButton.isSelected()) {
            p = JMeterUtils.getJMeterProperties();
        }
        if (p == null) {
            return;
        }
        Set<Map.Entry<Object, Object>> s = p.entrySet();
        ArrayList<Map.Entry<Object, Object>> al = new ArrayList<Map.Entry<Object, Object>>(s);
        Collections.sort(al, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                String m1 = (String)o1.getKey();
                String m2 = (String)o2.getKey();
                return m1.compareTo(m2);
            }
        });
        Iterator<Map.Entry<Object, Object>> i = al.iterator();
        while (i.hasNext()) {
            this.tableModel.addRow(i.next());
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
    }

    private Component makeMainPanel() {
        this.initializeTableModel();
        this.table = new JTable((TableModel)this.tableModel);
        this.table.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(0);
        return this.makeScrollPane(this.table);
    }

    private Component makeLabelPanel() {
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.systemButton);
        bg.add(this.jmeterButton);
        this.jmeterButton.setSelected(true);
        this.systemButton.setActionCommand(SYSTEM);
        this.jmeterButton.setActionCommand(JMETER);
        this.systemButton.addActionListener(this);
        this.jmeterButton.addActionListener(this);
        labelPanel.add(this.systemButton);
        labelPanel.add(this.jmeterButton);
        labelPanel.add(this.tableLabel);
        return labelPanel;
    }

    private void init() {
        Object p = this;
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        p = new JPanel();
        ((Container)p).setLayout(new BorderLayout());
        ((Container)p).add(this.makeLabelPanel(), "North");
        ((Container)p).add(this.makeMainPanel(), "Center");
        ((Container)p).add(Box.createVerticalStrut(70), "West");
        this.add((Component)p, "Center");
        this.table.revalidate();
    }

    private void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{COLUMN_NAMES_0, COLUMN_NAMES_1}, new Functor[]{new Functor(Map.Entry.class, "getKey"), new Functor(Map.Entry.class, "getValue")}, new Functor[]{null, new Functor(Map.Entry.class, "setValue", new Class[]{Object.class})}, new Class[]{String.class, String.class});
    }
}

