/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class HttpClientDefaultParameters {
    private static final Logger log = LoggingManager.getLoggerForClass();

    private HttpClientDefaultParameters() {
    }

    public static void load(String file, final HttpParams params) {
        HttpClientDefaultParameters.load(file, new GenericHttpParams(){

            public void setParameter(String name, Object value) {
                params.setParameter(name, value);
            }

            public void setVersion(String name, String value) throws Exception {
                params.setParameter(name, (Object)HttpVersion.parse((String)("HTTP/" + value)));
            }
        });
    }

    public static void load(String file, final org.apache.http.params.HttpParams params) {
        HttpClientDefaultParameters.load(file, new GenericHttpParams(){

            public void setParameter(String name, Object value) {
                params.setParameter(name, value);
            }

            public void setVersion(String name, String value) {
                String[] parts = value.split("\\.");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Version must have form m.n");
                }
                params.setParameter(name, (Object)new org.apache.http.HttpVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void load(String file, GenericHttpParams params) {
        log.info("Reading httpclient parameters from " + file);
        File f = new File(file);
        FileInputStream is = null;
        Properties props = new Properties();
        try {
            try {
                is = new FileInputStream(f);
                props.load(is);
                for (Map.Entry<Object, Object> me : props.entrySet()) {
                    String key = (String)me.getKey();
                    String value = (String)me.getValue();
                    int typeSep = key.indexOf("$");
                    try {
                        if (typeSep > 0) {
                            String type = key.substring(typeSep + 1);
                            String name = key.substring(0, typeSep);
                            log.info("Defining " + name + " as " + value + " (" + type + ")");
                            if (type.equals("Integer")) {
                                params.setParameter(name, Integer.valueOf(value));
                                continue;
                            }
                            if (type.equals("Long")) {
                                params.setParameter(name, Long.valueOf(value));
                                continue;
                            }
                            if (type.equals("Boolean")) {
                                params.setParameter(name, Boolean.valueOf(value));
                                continue;
                            }
                            if (type.equals("HttpVersion")) {
                                params.setVersion(name, value);
                                continue;
                            }
                            log.warn("Unexpected type: " + type + " for name " + name);
                            continue;
                        }
                        log.info("Defining " + key + " as " + value);
                        params.setParameter(key, value);
                    }
                    catch (Exception e) {
                        log.error("Error in property: " + key + "=" + value + " " + e.toString());
                    }
                }
                Object var13_15 = null;
            }
            catch (FileNotFoundException e) {
                log.error("Problem loading properties " + e.toString());
                Object var13_16 = null;
                JOrphanUtils.closeQuietly((Closeable)is);
                return;
            }
            catch (IOException e) {
                log.error("Problem loading properties " + e.toString());
                Object var13_17 = null;
                JOrphanUtils.closeQuietly((Closeable)is);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            JOrphanUtils.closeQuietly((Closeable)is);
            throw throwable;
        }
        JOrphanUtils.closeQuietly((Closeable)is);
    }

    private static abstract class GenericHttpParams {
        private GenericHttpParams() {
        }

        public abstract void setParameter(String var1, Object var2);

        public abstract void setVersion(String var1, String var2) throws Exception;
    }
}

