/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.io.IOException;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.JSR223TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSR223Sampler
extends JSR223TestElement
implements Cloneable,
Sampler,
TestBean {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggingManager.getLoggerForClass();

    public SampleResult sample(Entry entry) {
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        String filename = this.getFilename();
        if (filename.length() > 0) {
            result.setSamplerData("File: " + filename);
        } else {
            result.setSamplerData(this.getScript());
        }
        result.setDataType("text");
        result.sampleStart();
        try {
            ScriptEngineManager mgr = this.getManager();
            if (mgr == null) {
                result.setSuccessful(false);
                result.setResponseCode("500");
                result.setResponseMessage("Could not instantiate ScriptManager");
                return result;
            }
            mgr.put("SampleResult", result);
            Object ret = this.processFileOrScript(mgr);
            result.setSuccessful(true);
            result.setResponseCodeOK();
            result.setResponseMessageOK();
            if (ret != null) {
                result.setResponseData(ret.toString(), null);
            }
        }
        catch (IOException e) {
            log.warn("Problem in JSR223 script " + e);
            result.setSuccessful(false);
            result.setResponseCode("500");
            result.setResponseMessage(e.toString());
        }
        catch (ScriptException e) {
            log.warn("Problem in JSR223 script " + e);
            result.setSuccessful(false);
            result.setResponseCode("500");
            result.setResponseMessage(e.toString());
        }
        result.sampleEnd();
        return result;
    }
}

