/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.monitor.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jmeter.monitor.model.ObjectFactory;
import org.apache.jmeter.monitor.model.Status;
import org.apache.jmeter.monitor.parser.MonitorHandler;
import org.apache.jmeter.monitor.parser.Parser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ParserImpl
implements Parser {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final SAXParser PARSER;
    private final MonitorHandler DOCHANDLER;
    private final ObjectFactory FACTORY;

    public ParserImpl(ObjectFactory factory) {
        this.FACTORY = factory;
        SAXParser parser = null;
        MonitorHandler handler = null;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parser = parserFactory.newSAXParser();
            handler = new MonitorHandler(this.FACTORY);
        }
        catch (SAXException e) {
            log.error("Failed to create the parser", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error("Failed to create the parser", (Throwable)e);
        }
        this.PARSER = parser;
        this.DOCHANDLER = handler;
    }

    public Status parseBytes(byte[] bytes) {
        try {
            InputSource is = new InputSource();
            is.setByteStream(new ByteArrayInputStream(bytes));
            this.PARSER.parse(is, (DefaultHandler)this.DOCHANDLER);
            return this.DOCHANDLER.getContents();
        }
        catch (SAXException e) {
            log.error("Failed to parse the bytes", (Throwable)e);
            return this.DOCHANDLER.getContents();
        }
        catch (IOException e) {
            log.error("Failed to read the bytes", (Throwable)e);
            return this.DOCHANDLER.getContents();
        }
    }

    public Status parseString(String content) {
        try {
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(content));
            this.PARSER.parse(is, (DefaultHandler)this.DOCHANDLER);
            return this.DOCHANDLER.getContents();
        }
        catch (SAXException e) {
            log.error("Failed to parse the String", (Throwable)e);
            return this.DOCHANDLER.getContents();
        }
        catch (IOException e) {
            log.error("Failed to read the String", (Throwable)e);
            return this.DOCHANDLER.getContents();
        }
    }

    public Status parseSampleResult(SampleResult result) {
        return this.parseBytes(result.getResponseData());
    }
}

