/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.visualizers.MonitorAccumModel;
import org.apache.jmeter.visualizers.MonitorGuiListener;
import org.apache.jmeter.visualizers.MonitorModel;

public class MonitorGraph
extends JComponent
implements MonitorGuiListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private final MonitorAccumModel model;
    private MonitorModel current;
    private boolean drawHealth = true;
    private boolean drawLoad = true;
    private boolean drawMemory = true;
    private boolean drawThread = true;
    private final boolean drawYgrid = true;
    private final boolean drawXgrid = true;

    @Deprecated
    public MonitorGraph() {
        this.model = null;
    }

    public MonitorGraph(MonitorAccumModel model) {
        this.model = model;
        this.repaint();
    }

    public void setHealth(boolean health) {
        this.drawHealth = health;
    }

    public void setLoad(boolean load) {
        this.drawLoad = load;
    }

    public void setMem(boolean mem) {
        this.drawMemory = mem;
    }

    public void setThread(boolean thread) {
        this.drawThread = thread;
    }

    public void updateGui(MonitorModel model) {
        if (this.isShowing()) {
            this.current = model;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.current != null) {
            MonitorAccumModel monitorAccumModel = this.model;
            synchronized (monitorAccumModel) {
                List<MonitorModel> samples = this.model.getAllSamples(this.current.getURL());
                int size = samples.size();
                List<MonitorModel> list = samples;
                synchronized (list) {
                    Iterator<MonitorModel> e = size > this.getWidth() ? samples.listIterator(size - this.getWidth()) : samples.iterator();
                    MonitorModel last = null;
                    int i = 0;
                    while (e.hasNext()) {
                        MonitorModel s = e.next();
                        if (last == null) {
                            last = s;
                        }
                        this.drawSample(i, s, g, last);
                        last = s;
                        ++i;
                    }
                }
            }
        }
    }

    public void updateGui() {
        this.repaint();
    }

    public void clearData() {
        this.paintComponent(this.getGraphics());
        this.repaint();
    }

    private void drawSample(int x, MonitorModel model, Graphics g, MonitorModel last) {
        double width = this.getWidth();
        double height = (double)this.getHeight() - 10.0;
        int xaxis = (int)(width * ((double)x / width));
        int lastx = (int)(width * ((double)(x - 1) / width));
        if (x == 1) {
            int q1 = (int)(height * 0.25);
            int q2 = (int)(height * 0.5);
            int q3 = (int)(height * 0.75);
            g.setColor(Color.lightGray);
            g.drawLine(0, q1, this.getWidth(), q1);
            g.drawLine(0, q2, this.getWidth(), q2);
            g.drawLine(0, q3, this.getWidth(), q3);
        }
        if (x == 1) {
            int x1 = (int)(width * 0.25);
            int x2 = (int)(width * 0.5);
            int x3 = (int)(width * 0.75);
            g.drawLine(x1, 0, x1, this.getHeight());
            g.drawLine(x2, 0, x2, this.getHeight());
            g.drawLine(x3, 0, x3, this.getHeight());
            g.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
        }
        if (this.drawHealth) {
            int hly = (int)(height - height * ((double)model.getHealth() / 3.0));
            int lasty = (int)(height - height * ((double)last.getHealth() / 3.0));
            g.setColor(Color.green);
            g.drawLine(lastx, lasty, xaxis, hly);
        }
        if (this.drawLoad) {
            int ldy = (int)(height - height * ((double)model.getLoad() / 100.0));
            int lastldy = (int)(height - height * ((double)last.getLoad() / 100.0));
            g.setColor(Color.blue);
            g.drawLine(lastx, lastldy, xaxis, ldy);
        }
        if (this.drawMemory) {
            int mmy = (int)(height - height * ((double)model.getMemload() / 100.0));
            int lastmmy = (int)(height - height * ((double)last.getMemload() / 100.0));
            g.setColor(Color.orange);
            g.drawLine(lastx, lastmmy, xaxis, mmy);
        }
        if (this.drawThread) {
            int thy = (int)(height - height * ((double)model.getThreadload() / 100.0));
            int lastthy = (int)(height - height * ((double)last.getThreadload() / 100.0));
            g.setColor(Color.red);
            g.drawLine(lastx, lastthy, xaxis, thy);
        }
    }
}

