/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.ReportMenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.report.gui.AbstractReportGui;
import org.apache.jmeter.testelement.AbstractChart;
import org.apache.jmeter.testelement.AbstractTable;
import org.apache.jmeter.testelement.BarChart;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;

public class BarChartGui
extends AbstractReportGui {
    private static final long serialVersionUID = 240L;
    private JLabeledChoice xAxisLabel = new JLabeledChoice();
    private JLabeledTextField yAxisLabel = new JLabeledTextField(JMeterUtils.getResString((String)"report_chart_y_axis_label"));
    private JLabeledTextField caption = new JLabeledTextField(JMeterUtils.getResString((String)"report_chart_caption"), Color.white);
    private JLabeledTextField url = new JLabeledTextField(JMeterUtils.getResString((String)"report_bar_graph_url"), Color.white);
    private JLabeledChoice yItems = new JLabeledChoice();
    private JLabeledChoice xItems = new JLabeledChoice();

    public BarChartGui() {
        this.init();
    }

    public String getLabelResource() {
        return "report_bar_chart";
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        ReportMenuFactory.addFileMenu(pop);
        ReportMenuFactory.addEditMenu(pop, true);
        return pop;
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.setBackground(Color.white);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(10, 10));
        pane.setBackground(Color.white);
        pane.add((Component)this.getNamePanel(), "North");
        VerticalPanel options = new VerticalPanel(Color.white);
        this.xAxisLabel.setBackground(Color.white);
        this.yAxisLabel.setBackground(Color.white);
        JLabel xLabel = new JLabel(JMeterUtils.getResString((String)"report_chart_x_axis"));
        HorizontalPanel xpanel = new HorizontalPanel(Color.white);
        xLabel.setBorder(new EmptyBorder(5, 2, 5, 2));
        this.xItems.setBackground(Color.white);
        this.xItems.setValues(AbstractTable.xitems);
        xpanel.add((Component)xLabel);
        xpanel.add((Component)this.xItems);
        options.add((Component)xpanel);
        JLabel xALabel = new JLabel(JMeterUtils.getResString((String)"report_chart_x_axis_label"));
        HorizontalPanel xApanel = new HorizontalPanel(Color.white);
        xALabel.setBorder(new EmptyBorder(5, 2, 5, 2));
        this.xAxisLabel.setBackground(Color.white);
        this.xAxisLabel.setValues(AbstractChart.X_LABELS);
        xApanel.add((Component)xALabel);
        xApanel.add((Component)this.xAxisLabel);
        options.add((Component)xApanel);
        JLabel yLabel = new JLabel(JMeterUtils.getResString((String)"report_chart_y_axis"));
        HorizontalPanel ypanel = new HorizontalPanel(Color.white);
        yLabel.setBorder(new EmptyBorder(5, 2, 5, 2));
        this.yItems.setBackground(Color.white);
        this.yItems.setValues(AbstractTable.items);
        ypanel.add((Component)yLabel);
        ypanel.add((Component)this.yItems);
        options.add((Component)ypanel);
        options.add((Component)this.yAxisLabel);
        options.add((Component)this.caption);
        options.add((Component)this.url);
        this.add(pane, "North");
        this.add((Component)options, "Center");
    }

    public TestElement createTestElement() {
        BarChart element = new BarChart();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        BarChart bc = (BarChart)element;
        bc.setXAxis(this.xItems.getText());
        bc.setYAxis(this.yItems.getText());
        bc.setXLabel(this.xAxisLabel.getText());
        bc.setYLabel(this.yAxisLabel.getText());
        bc.setCaption(this.caption.getText());
        bc.setURL(this.url.getText());
    }

    public void configure(TestElement element) {
        super.configure(element);
        BarChart bc = (BarChart)element;
        this.xItems.setText(bc.getXAxis());
        this.yItems.setText(bc.getYAxis());
        this.xAxisLabel.setText(bc.getXLabel());
        this.yAxisLabel.setText(bc.getYLabel());
        this.caption.setText(bc.getCaption());
        this.url.setText(bc.getURL());
    }
}

