/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportActionRouter
implements ActionListener {
    private Map<String, Set<Command>> commands = new HashMap<String, Set<Command>>();
    private static volatile ReportActionRouter router;
    private static final Logger log;
    private static final Object LOCK;
    private Map<String, HashSet<ActionListener>> preActionListeners = new HashMap<String, HashSet<ActionListener>>();
    private Map<String, HashSet<ActionListener>> postActionListeners = new HashMap<String, HashSet<ActionListener>>();

    private ReportActionRouter() {
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportActionRouter.this.performAction(e);
            }
        });
    }

    private void performAction(ActionEvent e) {
        try {
            ReportGuiPackage.getInstance().updateCurrentNode();
            Set<Command> commandObjects = this.commands.get(e.getActionCommand());
            Iterator<Command> iter = commandObjects.iterator();
            while (iter.hasNext()) {
                try {
                    Command c = iter.next();
                    this.preActionPerformed(c.getClass(), e);
                    c.doAction(e);
                    this.postActionPerformed(c.getClass(), e);
                }
                catch (IllegalUserActionException err) {
                    JMeterUtils.reportErrorToUser((String)err.toString());
                }
                catch (Exception err) {
                    log.error("", (Throwable)err);
                }
            }
        }
        catch (NullPointerException er) {
            log.error("performAction(" + e.getActionCommand() + ") " + e.toString() + " caused", (Throwable)er);
            JMeterUtils.reportErrorToUser((String)("Sorry, this feature (" + e.getActionCommand() + ") not yet implemented"));
        }
    }

    public void doActionNow(ActionEvent e) {
        this.performAction(e);
    }

    public Set<Command> getAction(String actionName) {
        HashSet<Command> set = new HashSet<Command>();
        Set<Command> commandObjects = this.commands.get(actionName);
        Iterator<Command> iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                set.add(iter.next());
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return set;
    }

    public Command getAction(String actionName, Class<?> actionClass) {
        Set<Command> commandObjects = this.commands.get(actionName);
        Iterator<Command> iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                Command com = iter.next();
                if (!com.getClass().equals(actionClass)) continue;
                return com;
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return null;
    }

    public Command getAction(String actionName, String className) {
        Set<Command> commandObjects = this.commands.get(actionName);
        Iterator<Command> iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                Command com = iter.next();
                if (!com.getClass().getName().equals(className)) continue;
                return com;
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return null;
    }

    public void addPreActionListener(Class<?> action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = this.preActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet();
            }
            set.add(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void removePreActionListener(Class<?> action, ActionListener listener) {
        HashSet<ActionListener> set;
        if (action != null && (set = this.preActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void addPostActionListener(Class<?> action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = this.postActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet();
            }
            set.add(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    public void removePostActionListener(Class<?> action, ActionListener listener) {
        HashSet<ActionListener> set;
        if (action != null && (set = this.postActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    protected void preActionPerformed(Class<? extends Command> action, ActionEvent e) {
        HashSet<ActionListener> listenerSet;
        if (action != null && (listenerSet = this.preActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            Object[] listeners = listenerSet.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((ActionListener)listeners[i]).actionPerformed(e);
            }
        }
    }

    protected void postActionPerformed(Class<? extends Command> action, ActionEvent e) {
        HashSet<ActionListener> listenerSet;
        if (action != null && (listenerSet = this.postActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            Object[] listeners = listenerSet.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((ActionListener)listeners[i]).actionPerformed(e);
            }
        }
    }

    private void populateCommandMap() {
        log.info("populateCommandMap called");
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Class.forName("org.apache.jmeter.gui.action.Command")});
            this.commands = new HashMap<String, Set<Command>>(listClasses.size());
            if (listClasses.size() == 0) {
                log.warn("!!!!!Uh-oh, didn't find any action handlers!!!!!");
            }
            for (String strClassName : listClasses) {
                Class<?> commandClass;
                if (!strClassName.startsWith("org.apache.jmeter.report.gui.action") || Modifier.isAbstract((commandClass = Class.forName(strClassName)).getModifiers())) continue;
                Command command = (Command)commandClass.newInstance();
                for (String commandName : command.getActionNames()) {
                    Set<Command> commandObjects = this.commands.get(commandName);
                    if (commandObjects == null) {
                        commandObjects = new HashSet<Command>();
                        this.commands.put(commandName, commandObjects);
                    }
                    commandObjects.add(command);
                }
            }
        }
        catch (HeadlessException e) {
            log.warn(e.toString());
        }
        catch (Exception e) {
            log.error("exception finding action handlers", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportActionRouter getInstance() {
        if (router == null) {
            Object object = LOCK;
            synchronized (object) {
                if (router == null) {
                    router = new ReportActionRouter();
                    router.populateCommandMap();
                }
            }
        }
        return router;
    }

    static {
        log = LoggingManager.getLoggerForClass();
        LOCK = new Object();
    }
}

