/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAddParent
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();

    public void doAction(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        try {
            TestElement controller = ReportGuiPackage.getInstance().createTestElement(name);
            this.addParentToTree(controller);
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }

    public Set<String> getActionNames() {
        return commands;
    }

    protected void addParentToTree(TestElement newParent) {
        ReportGuiPackage guiPackage = ReportGuiPackage.getInstance();
        ReportTreeNode newNode = new ReportTreeNode(newParent, guiPackage.getTreeModel());
        ReportTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
        ReportTreeNode parentNode = (ReportTreeNode)currentNode.getParent();
        int index = parentNode.getIndex(currentNode);
        guiPackage.getTreeModel().insertNodeInto(newNode, parentNode, index);
        ReportTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            this.moveNode(guiPackage, nodes[i], newNode);
        }
    }

    private void moveNode(ReportGuiPackage guiPackage, ReportTreeNode node, ReportTreeNode newParentNode) {
        guiPackage.getTreeModel().removeNodeFromParent(node);
        guiPackage.getTreeModel().insertNodeInto(node, newParentNode, newParentNode.getChildCount());
    }

    static {
        commands.add("Add Parent");
    }
}

