/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.report.gui.action.AbstractAction;
import org.apache.jmeter.report.gui.tree.ReportTreeListener;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportCopy
extends AbstractAction {
    private static ReportTreeNode copiedNode = null;
    private static ReportTreeNode[] copiedNodes = null;
    private static final String COPY = "Copy";
    private static final HashSet<String> commands = new HashSet();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        ReportTreeListener treeListener = ReportGuiPackage.getInstance().getTreeListener();
        ReportTreeNode[] nodes = treeListener.getSelectedNodes();
        ReportCopy.setCopiedNodes(nodes);
    }

    public static ReportTreeNode[] getCopiedNodes() {
        for (int i = 0; i < copiedNodes.length; ++i) {
            if (copiedNodes[i] != null) continue;
            return null;
        }
        return ReportCopy.cloneTreeNodes(copiedNodes);
    }

    public static ReportTreeNode getCopiedNode() {
        if (copiedNode == null) {
            return null;
        }
        return ReportCopy.cloneTreeNode(copiedNode);
    }

    public static void setCopiedNode(ReportTreeNode node) {
        copiedNode = ReportCopy.cloneTreeNode(node);
    }

    public static ReportTreeNode cloneTreeNode(ReportTreeNode node) {
        ReportTreeNode treeNode = (ReportTreeNode)node.clone();
        treeNode.setUserObject(((TestElement)node.getUserObject()).clone());
        ReportCopy.cloneChildren(treeNode, node);
        return treeNode;
    }

    public static void setCopiedNodes(ReportTreeNode[] nodes) {
        copiedNodes = new ReportTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ReportCopy.copiedNodes[i] = ReportCopy.cloneTreeNode(nodes[i]);
        }
    }

    public static ReportTreeNode[] cloneTreeNodes(ReportTreeNode[] nodes) {
        ReportTreeNode[] treeNodes = new ReportTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            treeNodes[i] = ReportCopy.cloneTreeNode(nodes[i]);
        }
        return treeNodes;
    }

    private static void cloneChildren(ReportTreeNode to, ReportTreeNode from) {
        Enumeration<TreeNode> enumFrom = from.children();
        while (enumFrom.hasMoreElements()) {
            ReportTreeNode child = (ReportTreeNode)enumFrom.nextElement();
            ReportTreeNode childClone = (ReportTreeNode)child.clone();
            childClone.setUserObject(((TestElement)child.getUserObject()).clone());
            to.add(childClone);
            ReportCopy.cloneChildren((ReportTreeNode)to.getLastChild(), child);
        }
    }

    static {
        commands.add(COPY);
    }
}

