/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.ServerPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class TCPConfigGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 240L;
    private ServerPanel serverPanel;
    private JLabeledTextField classname;
    private JCheckBox reUseConnection;
    private JCheckBox setNoDelay;
    private JTextArea requestData;
    private boolean displayName = true;

    public TCPConfigGui() {
        this(true);
    }

    public TCPConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "tcp_config_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.classname.setText(element.getPropertyAsString("TCPSampler.classname"));
        this.serverPanel.setServer(element.getPropertyAsString("TCPSampler.server"));
        this.reUseConnection.setSelected(element.getPropertyAsBoolean("TCPSampler.reUseConnection", true));
        this.serverPanel.setPort(element.getPropertyAsString("TCPSampler.port"));
        this.serverPanel.setResponseTimeout(element.getPropertyAsString("TCPSampler.timeout"));
        this.serverPanel.setConnectTimeout(element.getPropertyAsString("TCPSampler.ctimeout"));
        this.setNoDelay.setSelected(element.getPropertyAsBoolean("TCPSampler.nodelay"));
        this.requestData.setText(element.getPropertyAsString("TCPSampler.request"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty("TCPSampler.classname", this.classname.getText(), "");
        element.setProperty("TCPSampler.server", this.serverPanel.getServer());
        element.setProperty("TCPSampler.reUseConnection", this.reUseConnection.isSelected());
        element.setProperty("TCPSampler.port", this.serverPanel.getPort());
        element.setProperty("TCPSampler.nodelay", this.setNoDelay.isSelected());
        element.setProperty("TCPSampler.timeout", this.serverPanel.getResponseTimeout());
        element.setProperty("TCPSampler.ctimeout", this.serverPanel.getConnectTimeout(), "");
        element.setProperty("TCPSampler.request", this.requestData.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.serverPanel.clear();
        this.classname.setText("");
        this.requestData.setText("");
        this.reUseConnection.setSelected(true);
        this.setNoDelay.setSelected(false);
    }

    private JPanel createNoDelayPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"tcp_nodelay"));
        this.setNoDelay = new JCheckBox();
        label.setLabelFor(this.setNoDelay);
        JPanel nodelayPanel = new JPanel(new BorderLayout(5, 0));
        nodelayPanel.add((Component)label, "West");
        nodelayPanel.add((Component)this.setNoDelay, "Center");
        return nodelayPanel;
    }

    private JPanel createClosePortPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"reuseconnection"));
        this.reUseConnection = new JCheckBox("", true);
        label.setLabelFor(this.reUseConnection);
        JPanel closePortPanel = new JPanel(new BorderLayout(5, 0));
        closePortPanel.add((Component)label, "West");
        closePortPanel.add((Component)this.reUseConnection, "Center");
        return closePortPanel;
    }

    private JPanel createRequestPanel() {
        JLabel reqLabel = new JLabel(JMeterUtils.getResString((String)"tcp_request_data"));
        this.requestData = new JTextArea(3, 0);
        this.requestData.setLineWrap(true);
        reqLabel.setLabelFor(this.requestData);
        JPanel reqDataPanel = new JPanel(new BorderLayout(5, 0));
        reqDataPanel.add((Component)reqLabel, "West");
        reqDataPanel.add((Component)this.requestData, "Center");
        return reqDataPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.serverPanel = new ServerPanel();
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        this.classname = new JLabeledTextField(JMeterUtils.getResString((String)"tcp_classname"));
        mainPanel.add((Component)this.classname);
        mainPanel.add((Component)this.serverPanel);
        HorizontalPanel optionsPanel = new HorizontalPanel();
        optionsPanel.add((Component)this.createClosePortPanel());
        optionsPanel.add((Component)this.createNoDelayPanel());
        mainPanel.add((Component)optionsPanel);
        mainPanel.add((Component)this.createRequestPanel());
        this.add((Component)mainPanel, "Center");
    }
}

