/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import kg.apc.jmeter.perfmon.agent.MetricsGetter;
import kg.apc.jmeter.perfmon.agent.ServerAgent;

public class ConnectionThread
extends Thread {
    private Socket socket = null;
    private static int currentId = 0;
    private int id;

    public ConnectionThread(Socket socket) {
        super("ConnectionThread");
        this.socket = socket;
        this.id = currentId++;
    }

    public void run() {
        MetricsGetter data = MetricsGetter.getInstance();
        ServerAgent.logMessage("Client id=" + this.id + " connected!");
        try {
            String inputLine;
            PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while ((inputLine = in.readLine()) != null && !inputLine.equals("bye")) {
                out.println(data.getValues(inputLine));
            }
            out.close();
            in.close();
            this.socket.close();
            ServerAgent.logMessage("Client id=" + this.id + " disconnected!");
        }
        catch (IOException e) {
            ServerAgent.logMessage(e.getMessage());
        }
    }
}

