/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon.agent;

import java.io.IOException;
import java.net.ServerSocket;
import kg.apc.jmeter.perfmon.agent.ConnectionThread;
import kg.apc.jmeter.perfmon.agent.MetricsGetter;

public class ServerAgent
implements Runnable {
    private static String version = "1.3";
    public static int DEFAULT_PORT = 4444;
    private int port = -1;
    private boolean listening = true;

    public ServerAgent(int port) {
        this.port = port;
    }

    public static void logMessage(String message) {
        System.out.println(message);
    }

    public void stopService() {
        this.listening = false;
    }

    public void startServiceAsThread() {
        Thread t = new Thread(this);
        t.start();
    }

    public void startServie() {
        this.listening = true;
        ServerSocket serverSocket = null;
        MetricsGetter.getInstance().getValues("cpu");
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            ServerAgent.logMessage("Could not listen on port: " + this.port + ". Please specify another port...");
            System.exit(-1);
        }
        ServerAgent.logMessage("Waiting for incoming connections...");
        while (this.listening) {
            try {
                new ConnectionThread(serverSocket.accept()).start();
            }
            catch (IOException e) {
                ServerAgent.logMessage("Impossible to create the connection with the client. Error is:");
                ServerAgent.logMessage(e.getMessage());
            }
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ServerAgent.logMessage("JMeterPlugins Agent version " + version);
        int port = DEFAULT_PORT;
        if (args.length > 0) {
            try {
                port = Integer.valueOf(args[0]);
                ServerAgent.logMessage("The Agent will use port: " + port);
            }
            catch (Exception e) {
                ServerAgent.logMessage("No valid port specified, the default value is used: " + port);
            }
        } else {
            ServerAgent.logMessage("No port specified, the default value is used: " + port);
        }
        ServerAgent agent = new ServerAgent(port);
        agent.startServie();
    }

    public void run() {
        this.startServie();
    }
}

