/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChart;
import kg.apc.jmeter.perfmon.AgentConnector;
import kg.apc.jmeter.perfmon.PerformanceMonitoringTestElement;
import kg.apc.jmeter.vizualizers.ColorsDispatcher;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import kg.apc.jmeter.vizualizers.GraphPanel;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import kg.apc.jmeter.vizualizers.SettingsInterface;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractPerformanceMonitoringGui
extends AbstractListenerGui
implements Clearable,
TableModelListener,
CellEditorListener,
GraphListener,
UnsharedComponent,
SettingsInterface {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected GraphPanel graphPanel;
    protected ConcurrentSkipListMap<String, AbstractGraphRow> model;
    protected ColorsDispatcher colors;
    private PowerTableModel tableModel;
    JTable grid;
    JButton addRowButton;
    JButton deleteRowButton;
    protected AgentConnector[] connectors = null;
    public static final String[] columnIdentifiers = new String[]{"Host / IP", "Port"};
    public static final Class[] columnClasses = new Class[]{String.class, Integer.class};
    private static Object[] defaultValues = new Object[]{"localhost", 4444};
    private ButtonGroup group = new ButtonGroup();
    private JRadioButton[] types = new JRadioButton[]{new JRadioButton("CPU"), new JRadioButton("Memory"), new JRadioButton("Swap"), new JRadioButton("Disks I/O"), new JRadioButton("Networks I/O")};
    public static final int PERFMON_CPU = 0;
    public static final int PERFMON_MEM = 1;
    public static final int PERFMON_SWAP = 2;
    public static final int PERFMON_DISKS_IO = 3;
    public static final int PERFMON_NETWORKS_IO = 4;
    protected int selectedPerfMonType = -1;
    private JSettingsPanel settingsPanel = null;

    public AbstractPerformanceMonitoringGui() {
        this.model = new ConcurrentSkipListMap();
        this.colors = new ColorsDispatcher();
        this.initGui();
    }

    public boolean isConnectorsValid() {
        return this.connectors != null && this.connectors.length > 0;
    }

    protected void updateAgentConnectors() {
        JMeterProperty props = ((PerformanceMonitoringTestElement)this.createTestElement()).getData();
        if (!(props instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)props;
            PropertyIterator iter = columns.iterator();
            List hosts = (List)iter.next().getObjectValue();
            List ports = (List)iter.next().getObjectValue();
            if (hosts.size() > 0) {
                this.connectors = new AgentConnector[hosts.size()];
                for (int i = 0; i < hosts.size(); ++i) {
                    StringProperty host = (StringProperty)hosts.get(i);
                    StringProperty port = (StringProperty)ports.get(i);
                    this.connectors[i] = new AgentConnector(host.getStringValue(), Integer.valueOf(port.getStringValue()));
                }
                this.selectedPerfMonType = this.getSelectedTypeIndex();
            } else {
                this.connectors = new AgentConnector[0];
            }
        } else {
            this.connectors = null;
        }
    }

    protected abstract JSettingsPanel getSettingsPanel();

    private void initGui() {
        VerticalPanel containerPanel = new VerticalPanel();
        containerPanel.add((Component)this.makeTitlePanel(), "North");
        containerPanel.add((Component)this.createParamsPanel(), "Center");
        containerPanel.add((Component)this.createMonitoringTypePanel(), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)containerPanel, "North");
        this.add(this.createGraphPanel(), "Center");
        this.settingsPanel = this.getSettingsPanel();
        this.graphPanel.getSettingsTab().add((Component)this.settingsPanel, "Center");
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Servers to monitor (must have started ServerAgent!)"));
        panel.setPreferredSize(new Dimension(150, 150));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        panel.add(this.createButtons(), "South");
        return panel;
    }

    private int getSelectedTypeIndex() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private void setSelectedType(int type) {
        this.types[type].setSelected(true);
    }

    private JPanel createMonitoringTypePanel() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Metrics to collect"));
        for (int i = 0; i < this.types.length; ++i) {
            this.group.add(this.types[i]);
            panel.add(this.types[i]);
        }
        this.types[0].setSelected(true);
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(Integer.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, columnClasses);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.grid.setModel((TableModel)this.tableModel);
    }

    private Component createButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.addRowButton = new JButton("Add One Server");
        this.deleteRowButton = new JButton("Remove Selected Server");
        buttonPanel.add(this.addRowButton);
        buttonPanel.add(this.deleteRowButton);
        this.addRowButton.addActionListener(new AddRowAction());
        this.deleteRowButton.addActionListener(new DeleteRowAction());
        return buttonPanel;
    }

    protected GraphPanel createGraphPanel() {
        this.graphPanel = new GraphPanel();
        this.graphPanel.getGraphObject().setRows(this.model);
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        return this.graphPanel;
    }

    public String getLabelResource() {
        return "performanceMonitoring";
    }

    public abstract String getStaticLabel();

    public TestElement createTestElement() {
        PerformanceMonitoringTestElement pmte = new PerformanceMonitoringTestElement();
        this.modifyTestElement((TestElement)pmte);
        return pmte;
    }

    public void modifyTestElement(TestElement te) {
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (te instanceof PerformanceMonitoringTestElement) {
            PerformanceMonitoringTestElement pmte = (PerformanceMonitoringTestElement)te;
            CollectionProperty rows = PerformanceMonitoringTestElement.tableModelToCollectionProperty(this.tableModel);
            pmte.setData(rows);
            pmte.setType(this.getSelectedTypeIndex());
        }
        super.configureTestElement(te);
    }

    public void configure(TestElement te) {
        super.configure(te);
        this.createTableModel();
        PerformanceMonitoringTestElement pmte = (PerformanceMonitoringTestElement)te;
        pmte.register(this);
        JMeterProperty perfmonValues = pmte.getData();
        if (!(perfmonValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)perfmonValues;
            PropertyIterator iter = columns.iterator();
            int count = 0;
            while (iter.hasNext()) {
                List list = (List)iter.next().getObjectValue();
                this.tableModel.setColumnData(count, list);
                ++count;
            }
            this.setSelectedType(pmte.getType());
        } else {
            log.warn("Received null property instead of collection");
        }
    }

    public void updateGui() {
        this.graphPanel.updateGui();
    }

    public void updateGui(Sample sample) {
        this.graphPanel.updateGui();
    }

    public void clearData() {
        this.model.clear();
        this.colors.reset();
        this.graphPanel.clearRowsTab();
        this.graphPanel.getGraphObject().clearErrorMessage();
        this.updateGui();
        this.repaint();
    }

    public void tableChanged(TableModelEvent e) {
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingCanceled(ChangeEvent e) {
    }

    public abstract void testStarted();

    public abstract void testEnded();

    public int getGranulation() {
        return 500;
    }

    public void setGranulation(int granulation) {
    }

    public GraphPanelChart getGraphPanelChart() {
        return this.graphPanel.getGraphObject();
    }

    private class DeleteRowAction
    implements ActionListener {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int rowSelected;
            if (AbstractPerformanceMonitoringGui.this.grid.isEditing()) {
                TableCellEditor cellEditor = AbstractPerformanceMonitoringGui.this.grid.getCellEditor(AbstractPerformanceMonitoringGui.this.grid.getEditingRow(), AbstractPerformanceMonitoringGui.this.grid.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((rowSelected = AbstractPerformanceMonitoringGui.this.grid.getSelectedRow()) >= 0) {
                AbstractPerformanceMonitoringGui.this.tableModel.removeRow(rowSelected);
                AbstractPerformanceMonitoringGui.this.tableModel.fireTableDataChanged();
                if (AbstractPerformanceMonitoringGui.this.tableModel.getRowCount() == 0) {
                    AbstractPerformanceMonitoringGui.this.deleteRowButton.setEnabled(false);
                } else {
                    int rowToSelect = rowSelected;
                    if (rowSelected >= AbstractPerformanceMonitoringGui.this.tableModel.getRowCount()) {
                        rowToSelect = rowSelected - 1;
                    }
                    AbstractPerformanceMonitoringGui.this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
            }
        }
    }

    private class AddRowAction
    implements ActionListener {
        private AddRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractPerformanceMonitoringGui.this.grid.isEditing()) {
                TableCellEditor cellEditor = AbstractPerformanceMonitoringGui.this.grid.getCellEditor(AbstractPerformanceMonitoringGui.this.grid.getEditingRow(), AbstractPerformanceMonitoringGui.this.grid.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            AbstractPerformanceMonitoringGui.this.tableModel.addRow(defaultValues);
            AbstractPerformanceMonitoringGui.this.tableModel.fireTableDataChanged();
            AbstractPerformanceMonitoringGui.this.deleteRowButton.setEnabled(true);
            int rowToSelect = AbstractPerformanceMonitoringGui.this.tableModel.getRowCount() - 1;
            AbstractPerformanceMonitoringGui.this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }
}

