/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.net.SocketFactory;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphRowExactValues;
import kg.apc.jmeter.perfmon.AbstractPerformanceMonitoringGui;
import kg.apc.jmeter.perfmon.AgentConnector;
import kg.apc.jmeter.perfmon.TCPSocketFactory;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ServerPerfMonitoringGUI
extends AbstractPerformanceMonitoringGui
implements Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean testIsRunning = false;
    private int delay = 1000;
    private HashMap<String, Long> oldValues = new HashMap();
    private SocketFactory socketFactory = new TCPSocketFactory();

    public String getStaticLabel() {
        return "Servers Performance Monitoring";
    }

    private synchronized AbstractGraphRow getNewRow(String label) {
        AbstractGraphRow row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowExactValues();
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(0);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (AbstractGraphRow)this.model.get(label);
        }
        return row;
    }

    private void addPerfRecord(String serverName, double value) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(serverName);
        if (row == null) {
            row = this.getNewRow(serverName);
        }
        long now = System.currentTimeMillis();
        row.add(now - now % (long)this.delay, value);
    }

    public void testStarted() {
        this.graphPanel.getGraphObject().clearErrorMessage();
        this.oldValues.clear();
        this.updateAgentConnectors();
        if (this.isConnectorsValid()) {
            AgentConnector connector = null;
            try {
                if (!this.testIsRunning) {
                    for (int i = 0; i < this.connectors.length; ++i) {
                        connector = this.connectors[i];
                        connector.connect(this.socketFactory.createSocket(connector.getHost(), connector.getPort()));
                    }
                    Thread t = new Thread(this);
                    this.testIsRunning = true;
                    t.start();
                }
            }
            catch (UnknownHostException e) {
                this.graphPanel.getGraphObject().setErrorMessage("Unknown host exception occured. Please verify access to the server '" + connector.getHost() + "'.");
                this.graphPanel.getGraphObject().repaint();
            }
            catch (IOException e) {
                this.graphPanel.getGraphObject().setErrorMessage("Enable to connect to server '" + connector.getHost() + "'. Please verify the agent is running on port " + connector.getPort() + ".");
                this.graphPanel.getGraphObject().repaint();
            }
        }
    }

    public void testEnded() {
        this.testIsRunning = false;
        if (this.isConnectorsValid()) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].disconnect();
            }
        }
    }

    public void run() {
        while (this.testIsRunning) {
            this.setSpecialChartType();
            try {
                this.processConnectors();
                this.updateGui();
                Thread.sleep(this.delay);
            }
            catch (Exception e) {
                log.error("Error in ServerPerfMonitoringGUI loop thread: ", (Throwable)e);
                this.testIsRunning = false;
            }
        }
    }

    private void processConnectors() throws IllegalArgumentException {
        for (int i = 0; i < this.connectors.length; ++i) {
            boolean success = true;
            switch (this.selectedPerfMonType) {
                case 0: {
                    success = this.addCPURecord(this.connectors[i]);
                    break;
                }
                case 1: {
                    success = this.addMemRecord(this.connectors[i]);
                    break;
                }
                case 2: {
                    success = this.addSwapRecord(this.connectors[i]);
                    break;
                }
                case 3: {
                    success = this.addDisksIORecord(this.connectors[i]);
                    break;
                }
                case 4: {
                    success = this.addNetworkRecord(this.connectors[i]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled perfmon type:" + this.selectedPerfMonType);
                }
            }
            if (success || !this.testIsRunning) continue;
            this.graphPanel.getGraphObject().setErrorMessage("Connection lost with '" + this.connectors[i].getHost() + "'!");
        }
    }

    private void setSpecialChartType() {
        if (this.selectedPerfMonType == 0) {
            this.graphPanel.getGraphObject().setChartType(0);
        } else {
            this.graphPanel.getGraphObject().setChartType(-1);
        }
    }

    private boolean addCPURecord(AgentConnector connector) {
        long value = (long)(100.0 * connector.getCpu());
        if (value >= 0L) {
            this.addPerfRecord(connector.getRemoteServerName(), value);
            return true;
        }
        return false;
    }

    private boolean addMemRecord(AgentConnector agentConnector) {
        double value = (double)agentConnector.getMem() / 1048576.0;
        if (value >= 0.0) {
            this.addPerfRecord(agentConnector.getRemoteServerName(), value);
            return true;
        }
        return false;
    }

    private boolean addSwapRecord(AgentConnector agentConnector) {
        long[] values = agentConnector.getSwap();
        if (values[0] == -2L || values[1] == -2L) {
            return false;
        }
        String keyPageIn = agentConnector.getRemoteServerName() + " page IN";
        String keyPageOut = agentConnector.getRemoteServerName() + " page OUT";
        if (this.oldValues.containsKey(keyPageIn) && this.oldValues.containsKey(keyPageOut)) {
            this.addPerfRecord(keyPageIn, values[0] - this.oldValues.get(keyPageIn));
            this.addPerfRecord(keyPageOut, values[1] - this.oldValues.get(keyPageOut));
        }
        this.oldValues.put(keyPageIn, new Long(values[0]));
        this.oldValues.put(keyPageOut, new Long(values[1]));
        return true;
    }

    private boolean addDisksIORecord(AgentConnector agentConnector) {
        long[] values = agentConnector.getDisksIO();
        if (values[0] == -2L || values[1] == -2L) {
            return false;
        }
        String keyReads = agentConnector.getRemoteServerName() + " READS";
        String keyWrites = agentConnector.getRemoteServerName() + " WRITES";
        if (this.oldValues.containsKey(keyReads) && this.oldValues.containsKey(keyWrites)) {
            this.addPerfRecord(keyReads, values[0] - this.oldValues.get(keyReads));
            this.addPerfRecord(keyWrites, values[1] - this.oldValues.get(keyWrites));
        }
        this.oldValues.put(keyReads, new Long(values[0]));
        this.oldValues.put(keyWrites, new Long(values[1]));
        return true;
    }

    private boolean addNetworkRecord(AgentConnector agentConnector) {
        long[] values = agentConnector.getNetIO();
        if (values[0] == -2L || values[1] == -2L) {
            return false;
        }
        String keyReads = agentConnector.getRemoteServerName() + " RECEIVED";
        String keyWrites = agentConnector.getRemoteServerName() + " TRANSFERED";
        if (this.oldValues.containsKey(keyReads) && this.oldValues.containsKey(keyWrites)) {
            this.addPerfRecord(keyReads, (double)(values[0] - this.oldValues.get(keyReads)) / 1024.0);
            this.addPerfRecord(keyWrites, (double)(values[1] - this.oldValues.get(keyWrites)) / 1024.0);
        }
        this.oldValues.put(keyReads, new Long(values[0]));
        this.oldValues.put(keyWrites, new Long(values[1]));
        return true;
    }

    void setSocketFactory(SocketFactory sf) {
        this.socketFactory = sf;
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, false, true, false, false, true);
    }
}

