/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import kg.apc.jmeter.samplers.DummySampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class DummySamplerGui
extends AbstractSamplerGui {
    private JCheckBox isSuccessful;
    private JTextField responseCode;
    private JTextField responseMessage;
    private JTextField responseTime;
    private JTextArea responseData;

    public DummySamplerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return "Dummy Sampler";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.isSuccessful.setSelected(element.getPropertyAsBoolean("SUCCESFULL"));
        this.responseCode.setText(element.getPropertyAsString("RESPONSE_CODE"));
        this.responseMessage.setText(element.getPropertyAsString("RESPONSE_MESSAGE"));
        this.responseData.setText(element.getPropertyAsString("RESPONSE_DATA"));
        this.responseTime.setText(element.getPropertyAsString("RESPONSE_TIME"));
    }

    public TestElement createTestElement() {
        DummySampler sampler = new DummySampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        super.configureTestElement(sampler);
        if (sampler instanceof DummySampler) {
            DummySampler dummySampler = (DummySampler)sampler;
            dummySampler.setSuccessful(this.isSuccessful.isSelected());
            dummySampler.setResponseCode(this.responseCode.getText());
            dummySampler.setResponseMessage(this.responseMessage.getText());
            dummySampler.setResponseData(this.responseData.getText());
            dummySampler.setResponseTime(this.responseTime.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.isSuccessful.setSelected(true);
        this.responseCode.setText("200");
        this.responseMessage.setText("OK");
        this.responseData.setText("");
        this.responseTime.setText("100");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Successfull sample: ", 4));
        this.isSuccessful = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.isSuccessful);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Response Code (eg 200): ", 4));
        this.responseCode = new JTextField();
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.responseCode);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Response Message (eg OK): ", 4));
        this.responseMessage = new JTextField();
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.responseMessage);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Response Time (milliseconds): ", 4));
        this.responseTime = new JTextField();
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.responseTime);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Response Data: ", 4));
        editConstraints.fill = 1;
        this.responseData = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.responseData);
        this.responseData.setRows(10);
        this.responseData.setBorder(new BevelBorder(1));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }
}

