/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kg.apc.jmeter.charting.AbstractGraphPanelChartElement;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChart;
import kg.apc.jmeter.charting.GraphRowSumValues;
import kg.apc.jmeter.threads.SteppingThreadGroup;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SteppingThreadGroupGui
extends AbstractThreadGroupGui {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentHashMap<String, AbstractGraphRow> model;
    private GraphPanelChart chart;
    private JTextField initialDelay;
    private JTextField incUserCount;
    private JTextField incUserPeriod;
    private JTextField flightTime;
    private JTextField decUserCount;
    private JTextField decUserPeriod;
    private JTextField totalThreads;
    private LoopControlPanel loopPanel;

    public SteppingThreadGroupGui() {
        this.init();
    }

    protected final void init() {
        JPanel containerPanel = new JPanel(new BorderLayout());
        containerPanel.add((Component)this.createParamsPanel(), "North");
        this.chart = new GraphPanelChart();
        this.model = new ConcurrentHashMap();
        this.chart.setRows(this.model);
        this.chart.setDrawFinalZeroingLines(true);
        this.chart.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        containerPanel.add((Component)this.chart, "Center");
        this.add(containerPanel, "Center");
        this.createControllerPanel();
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 5, 5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Threads Scheduling Parameters"));
        panel.add(new JLabel());
        panel.add(new JLabel("This group will start", 4));
        this.totalThreads = new JTextField("100", 5);
        panel.add(this.totalThreads);
        panel.add(new JLabel("threads:", 2));
        panel.add(new JLabel());
        panel.add(new JLabel("First, wait for", 4));
        this.initialDelay = new JTextField("5", 5);
        panel.add(this.initialDelay);
        panel.add(new JLabel("seconds.", 2));
        panel.add(new JLabel());
        panel.add(new JLabel());
        panel.add(new JLabel("Then start", 4));
        this.incUserCount = new JTextField("10", 5);
        panel.add(this.incUserCount);
        panel.add(new JLabel("threads every", 0));
        this.incUserPeriod = new JTextField("30", 5);
        panel.add(this.incUserPeriod);
        panel.add(new JLabel("seconds.", 2));
        panel.add(new JLabel("Then work for", 4));
        this.flightTime = new JTextField("60", 5);
        panel.add(this.flightTime);
        panel.add(new JLabel("seconds.", 2));
        panel.add(new JLabel());
        panel.add(new JLabel());
        panel.add(new JLabel("Finally, stop", 4));
        this.decUserCount = new JTextField("5", 5);
        panel.add(this.decUserCount);
        panel.add(new JLabel("threads every", 0));
        this.decUserPeriod = new JTextField("1", 5);
        panel.add(this.decUserPeriod);
        panel.add(new JLabel("seconds.", 2));
        this.registerJTextfieldForGraphRefresh(this.totalThreads);
        this.registerJTextfieldForGraphRefresh(this.initialDelay);
        this.registerJTextfieldForGraphRefresh(this.incUserCount);
        this.registerJTextfieldForGraphRefresh(this.incUserPeriod);
        this.registerJTextfieldForGraphRefresh(this.flightTime);
        this.registerJTextfieldForGraphRefresh(this.decUserCount);
        this.registerJTextfieldForGraphRefresh(this.decUserPeriod);
        return panel;
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Stepping Thread Group";
    }

    public TestElement createTestElement() {
        SteppingThreadGroup tg = new SteppingThreadGroup();
        this.modifyTestElement((TestElement)tg);
        return tg;
    }

    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        tg.setProperty("ThreadGroup.num_threads", this.totalThreads.getText());
        tg.setProperty("Threads initial delay", this.initialDelay.getText());
        tg.setProperty("Start users count", this.incUserCount.getText());
        tg.setProperty("Start users period", this.incUserPeriod.getText());
        tg.setProperty("Stop users count", this.decUserCount.getText());
        tg.setProperty("Stop users period", this.decUserPeriod.getText());
        tg.setProperty("flighttime", this.flightTime.getText());
        if (tg instanceof SteppingThreadGroup) {
            this.updateChart((SteppingThreadGroup)tg);
            ((AbstractThreadGroup)tg).setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
    }

    public void configure(TestElement tg) {
        super.configure(tg);
        this.totalThreads.setText(Integer.toString(tg.getPropertyAsInt("ThreadGroup.num_threads")));
        this.initialDelay.setText(Integer.toString(tg.getPropertyAsInt("Threads initial delay")));
        this.incUserCount.setText(Integer.toString(tg.getPropertyAsInt("Start users count")));
        this.incUserPeriod.setText(Integer.toString(tg.getPropertyAsInt("Start users period")));
        this.decUserCount.setText(Integer.toString(tg.getPropertyAsInt("Stop users count")));
        this.decUserPeriod.setText(Integer.toString(tg.getPropertyAsInt("Stop users period")));
        this.flightTime.setText(Integer.toString(tg.getPropertyAsInt("flighttime")));
        TestElement te = (TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue();
        if (te != null) {
            this.loopPanel.configure(te);
        }
    }

    private void updateChart() {
        log.debug("Updating chart...");
        TestElement tg = this.createTestElement();
        this.updateChart((SteppingThreadGroup)tg);
    }

    private void updateChart(SteppingThreadGroup tg) {
        int n;
        this.model.clear();
        GraphRowSumValues row = new GraphRowSumValues();
        row.setColor(Color.RED);
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        HashTree hashTree = new HashTree();
        hashTree.add((Object)new LoopController());
        JMeterThread thread = new JMeterThread(hashTree, null, null);
        row.add(System.currentTimeMillis(), 0.0);
        row.add(System.currentTimeMillis() + (long)tg.getThreadGroupDelay(), 0.0);
        int numThreads = tg.getNumThreads();
        for (n = 0; n < numThreads; ++n) {
            thread.setThreadNum(n);
            tg.scheduleThread(thread);
            row.add(thread.getStartTime() - 1L, 0.0);
            row.add(thread.getStartTime(), 1.0);
        }
        for (n = 0; n < numThreads; ++n) {
            thread.setThreadNum(n);
            tg.scheduleThread(thread);
            row.add(thread.getEndTime() - 1L, 0.0);
            row.add(thread.getEndTime(), -1.0);
        }
        this.calculateRowMaxY(row);
        this.model.put("Expected parallel users count", row);
        this.chart.repaint();
    }

    private void calculateRowMaxY(GraphRowSumValues row) {
        double max = Double.MIN_VALUE;
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = row.iterator();
        while (it.hasNext()) {
            double el = it.next().getValue().getValue();
            if (!(el > max)) continue;
            max = el;
        }
        row.setMaxY(max);
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(-1);
        looper.setContinueForever(true);
        this.loopPanel.configure((TestElement)looper);
        return this.loopPanel;
    }

    private void registerJTextfieldForGraphRefresh(JTextField tf) {
        tf.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                SteppingThreadGroupGui.this.updateChart();
            }

            public void insertUpdate(DocumentEvent arg0) {
                SteppingThreadGroupGui.this.updateChart();
            }

            public void removeUpdate(DocumentEvent arg0) {
                SteppingThreadGroupGui.this.updateChart();
            }
        });
    }
}

