/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.util.Iterator;
import java.util.List;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterThread;

class ThreadScheduleParams {
    int initialDelay;
    int startRampUp;
    int flightTime;
    int threadSeqNum;
    int numThreads;
    int endRampUp;
    private final JMeterThread currentThread;
    private final CollectionProperty columns;

    ThreadScheduleParams(JMeterThread thread, JMeterProperty aData) {
        this.currentThread = thread;
        if (aData instanceof NullProperty) {
            throw new IllegalArgumentException("Received null property instead of collection");
        }
        this.columns = (CollectionProperty)aData;
        this.numThreads = this.getCell(0);
        this.initialDelay = this.getCell(1);
        this.startRampUp = this.getCell(2);
        this.flightTime = this.getCell(3);
        this.endRampUp = this.getCell(4);
    }

    private int getCell(int col) {
        List column = (List)this.columns.get(col).getObjectValue();
        Iterator it = ((List)this.columns.get(0).getObjectValue()).iterator();
        int row = 0;
        int threadNo = this.currentThread.getThreadNum();
        while (it.hasNext()) {
            int threads = ((StringProperty)it.next()).getIntValue();
            if (threads > threadNo) {
                this.threadSeqNum = threadNo;
                JMeterProperty cell = (JMeterProperty)column.get(row);
                return cell.getIntValue() < 0 ? 0 : cell.getIntValue();
            }
            threadNo -= threads;
            ++row;
        }
        throw new IllegalArgumentException("Thread record not found for col " + col);
    }
}

