/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kg.apc.jmeter.threads.ThreadScheduleParams;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterThread;

public class UltimateThreadGroup
extends AbstractThreadGroup
implements Serializable {
    public static final String DATA_PROPERTY = "ultimatethreadgroupdata";

    public static CollectionProperty tableModelToCollectionProperty(PowerTableModel model) {
        CollectionProperty rows = new CollectionProperty(DATA_PROPERTY, new ArrayList());
        for (int col = 0; col < model.getColumnCount(); ++col) {
            rows.addItem((Object)model.getColumnData(model.getColumnName(col)));
        }
        return rows;
    }

    public void scheduleThread(JMeterThread thread) {
        ThreadScheduleParams params = new ThreadScheduleParams(thread, this.getData());
        long ascentPoint = System.currentTimeMillis() + (long)(1000 * params.initialDelay);
        int rampUpDelayForThread = (int)Math.floor((double)(1000 * params.startRampUp) * (double)params.threadSeqNum / (double)params.numThreads);
        long startTime = ascentPoint + (long)rampUpDelayForThread;
        long descentPoint = startTime + (long)(1000 * params.flightTime) + (long)(1000 * params.startRampUp) - (long)rampUpDelayForThread;
        thread.setStartTime(startTime);
        thread.setEndTime(descentPoint + (long)((int)Math.floor((double)(1000 * params.endRampUp) * (double)params.threadSeqNum / (double)params.numThreads)));
        thread.setScheduled(true);
    }

    public JMeterProperty getData() {
        JMeterProperty prop = this.getProperty(DATA_PROPERTY);
        return prop;
    }

    void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public int getNumThreads() {
        int result = 0;
        JMeterProperty threadValues = this.getData();
        if (!(threadValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)threadValues;
            List col = (List)columns.get(0).getObjectValue();
            for (StringProperty prop : col) {
                result += prop.getIntValue();
            }
        }
        return result;
    }
}

