/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChart;
import kg.apc.jmeter.vizualizers.ChartRowsTable;

public class GraphPanel
extends JTabbedPane
implements ChangeListener {
    private GraphPanelChart graphTab;
    private JComponent rowsTab;
    private JComponent settingsTab;
    private ChartRowsTable table;

    public GraphPanel() {
        this.addGraphTab();
        this.addRowsTab();
        this.addOptionsTab();
        this.addChangeListener(this);
    }

    private void addRowsTab() {
        ImageIcon rowsIcon = GraphPanel.createImageIcon("checks.png");
        this.rowsTab = new JPanel(new BorderLayout());
        this.rowsTab.add(this.makeTable(), "Center");
        this.addTab("Rows", rowsIcon, this.rowsTab, "Select rows to display");
    }

    private void addOptionsTab() {
        ImageIcon icon = GraphPanel.createImageIcon("settings.png");
        this.settingsTab = new JPanel(new BorderLayout());
        this.addTab("Settings", icon, this.settingsTab, "Graph options");
    }

    private Component makeTable() {
        this.table = new ChartRowsTable();
        return this.makeScrollPane(this.table);
    }

    private JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    private void addGraphTab() {
        ImageIcon graphIcon = GraphPanel.createImageIcon("graph.png");
        this.graphTab = new GraphPanelChart();
        this.addTab("Chart", graphIcon, this.graphTab, "View chart");
    }

    private static ImageIcon createImageIcon(String path) {
        URL imgURL = GraphPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public void updateGui() {
        JComponent selectedTab = (JComponent)this.getSelectedComponent();
        selectedTab.updateUI();
        selectedTab.repaint();
    }

    Image getGraphImage() {
        Image result = this.graphTab.createImage(this.graphTab.getWidth(), this.graphTab.getHeight());
        if (result != null) {
            this.graphTab.paintComponent(result.getGraphics());
        }
        return result;
    }

    public GraphPanelChart getGraphObject() {
        return this.graphTab;
    }

    public void addRow(AbstractGraphRow row) {
        this.table.addRow(row);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateGui();
    }

    public void clearRowsTab() {
        this.table.clear();
    }

    public JComponent getSettingsTab() {
        return this.settingsTab;
    }
}

