/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphRowAverages;
import kg.apc.jmeter.vizualizers.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ThreadsStateOverTimeGui
extends AbstractGraphPanelVisualizer {
    public ThreadsStateOverTimeGui() {
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        this.graphPanel.getGraphObject().setDrawFinalZeroingLines(true);
    }

    private synchronized AbstractGraphRow getNewRow(String label) {
        AbstractGraphRow row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowAverages();
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(2);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (AbstractGraphRow)this.model.get(label);
        }
        return row;
    }

    private void addThreadGroupRecord(String threadGroupName, long time, int numThreads) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(threadGroupName);
        }
        row.add(time, numThreads);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Active Threads Over Time";
    }

    public void add(SampleResult res) {
        String threadName = res.getThreadName();
        threadName = threadName.lastIndexOf(" ") >= 0 ? threadName.substring(0, threadName.lastIndexOf(" ")) : threadName;
        this.addThreadGroupRecord(threadName, res.getEndTime() - res.getEndTime() % (long)this.getGranulation(), res.getGroupThreads());
        this.updateGui(null);
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, true, true, false, true, true);
    }
}

