/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphRowSumValues;
import kg.apc.jmeter.vizualizers.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class TotalTransactionsPerSecondGui
extends AbstractGraphPanelVisualizer {
    public TotalTransactionsPerSecondGui() {
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        this.graphPanel.getGraphObject().setDrawFinalZeroingLines(true);
        this.setGranulation(1000);
    }

    private synchronized AbstractGraphRow getNewRow(String label) {
        AbstractGraphRow row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowSumValues(false);
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(2);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (AbstractGraphRow)this.model.get(label);
        }
        return row;
    }

    private void addTransaction(String threadGroupName, long time, double count) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(threadGroupName);
        }
        if (this.getGranulation() > 0) {
            row.add(time, count * 1000.0 / (double)this.getGranulation());
        }
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Total Transactions Per Second";
    }

    public void add(SampleResult res) {
        if (res.isSuccessful()) {
            this.addTransaction("Total Failed Transactions", res.getEndTime() - res.getEndTime() % (long)this.getGranulation(), 0.0);
            this.addTransaction("Total Successful Transactions", res.getEndTime() - res.getEndTime() % (long)this.getGranulation(), 1.0);
        } else {
            this.addTransaction("Total Failed Transactions", res.getEndTime() - res.getEndTime() % (long)this.getGranulation(), 1.0);
        }
        this.updateGui(null);
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, true, true, false, true, true);
    }
}

