/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.bsf;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.Script;
import org.apache.commons.jexl.ScriptFactory;

public class JexlEngine
extends BSFEngineImpl {
    private JexlContext jc;

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.jc = JexlHelper.createContext();
        for (int i = 0; i < declaredBeans.size(); ++i) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.elementAt(i);
            this.jc.getVars().put(bean.name, bean.bean);
        }
    }

    public void terminate() {
        if (this.jc != null) {
            this.jc.getVars().clear();
            this.jc = null;
        }
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        this.jc.getVars().put(bean.name, bean.bean);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.jc.getVars().remove(bean.name);
    }

    public Object eval(String fileName, int lineNo, int colNo, Object expr) throws BSFException {
        if (expr == null) {
            return null;
        }
        try {
            Script jExpr = null;
            jExpr = expr instanceof File ? ScriptFactory.createScript((File)((File)expr)) : (expr instanceof URL ? ScriptFactory.createScript((URL)((URL)expr)) : ScriptFactory.createScript((String)((String)expr)));
            return jExpr.execute(this.jc);
        }
        catch (Exception e) {
            throw new BSFException(500, e.getMessage(), (Throwable)e);
        }
    }

    public void exec(String fileName, int lineNo, int colNo, Object script) throws BSFException {
        if (script == null) {
            return;
        }
        try {
            Script jExpr = null;
            jExpr = script instanceof File ? ScriptFactory.createScript((File)((File)script)) : (script instanceof URL ? ScriptFactory.createScript((URL)((URL)script)) : ScriptFactory.createScript((String)((String)script)));
            jExpr.execute(this.jc);
        }
        catch (Exception e) {
            throw new BSFException(500, e.getMessage(), (Throwable)e);
        }
    }

    public void iexec(String fileName, int lineNo, int colNo, Object script) throws BSFException {
        this.exec(fileName, lineNo, colNo, script);
    }

    public Object call(Object object, String name, Object[] args) throws BSFException {
        try {
            Class[] types = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = args[i].getClass();
            }
            Method m = object.getClass().getMethod(name, types);
            return m.invoke(object, args);
        }
        catch (Exception e) {
            throw new BSFException(500, e.getMessage(), (Throwable)e);
        }
    }
}

