/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.core.JsonChars;

public final class JsonObjectImpl
extends AbstractMap<String, JsonValue>
implements JsonObject,
Serializable {
    private Integer hashCode = null;
    private final Map<String, JsonValue> unmodifieableBackingMap;

    private <T> T value(String name, Class<T> clazz) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            return clazz.cast(v);
        }
        throw new NullPointerException("no mapping for " + name);
    }

    public JsonObjectImpl(Map<String, JsonValue> backingMap) {
        this.unmodifieableBackingMap = backingMap;
    }

    public JsonArray getJsonArray(String name) {
        return this.value(name, JsonArray.class);
    }

    public JsonObject getJsonObject(String name) {
        return this.value(name, JsonObject.class);
    }

    public JsonNumber getJsonNumber(String name) {
        return this.value(name, JsonNumber.class);
    }

    public JsonString getJsonString(String name) {
        return this.value(name, JsonString.class);
    }

    public String getString(String name) {
        JsonString str = this.getJsonString(name);
        return str != null ? str.getString() : null;
    }

    public String getString(String name, String defaultValue) {
        try {
            return this.getJsonString(name).getString();
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    public int getInt(String name, int defaultValue) {
        try {
            return this.getJsonNumber(name).intValue();
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name) {
        return this.value(name, JsonValue.class) == JsonValue.TRUE;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            return this.getBoolean(name);
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public boolean isNull(String name) {
        return this.value(name, JsonValue.class) == JsonValue.NULL;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<Map.Entry<String, JsonValue>> it = this.unmodifieableBackingMap.entrySet().iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Map.Entry<String, JsonValue> entry = it.next();
            builder.append('\"').append(entry.getKey()).append("\":");
            JsonValue value = entry.getValue();
            if (JsonString.class.isInstance(value)) {
                builder.append(value.toString());
            } else {
                builder.append(value != JsonValue.NULL ? value.toString() : JsonChars.NULL);
            }
            if (!(hasNext = it.hasNext())) continue;
            builder.append(",");
        }
        return builder.append('}').toString();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonObjectImpl.class.isInstance(obj) && this.unmodifieableBackingMap.equals(((JsonObjectImpl)JsonObjectImpl.class.cast((Object)obj)).unmodifieableBackingMap);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.unmodifieableBackingMap.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.unmodifieableBackingMap.entrySet();
    }
}

