/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonInMemoryParser;
import org.apache.johnzon.core.JsonStreamParserImpl;

class JsonParserFactoryImpl
implements JsonParserFactory,
Serializable {
    public static final String BUFFER_STRATEGY = "org.apache.johnzon.buffer-strategy";
    public static final String MAX_STRING_LENGTH = "org.apache.johnzon.max-string-length";
    public static final String BUFFER_LENGTH = "org.apache.johnzon.default-char-buffer";
    public static final int DEFAULT_MAX_SIZE = Integer.getInteger("org.apache.johnzon.max-string-length", 262144);
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final String[] SUPPORTED_CONFIG_KEYS = new String[]{"org.apache.johnzon.buffer-strategy", "org.apache.johnzon.max-string-length", "org.apache.johnzon.default-char-buffer"};
    private final int maxSize;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final BufferStrategy.BufferProvider<char[]> valueBufferProvider;

    JsonParserFactoryImpl(Map<String, ?> config) {
        int bufferSize;
        if (config != null) {
            for (String configKey : SUPPORTED_CONFIG_KEYS) {
                if (!config.containsKey(configKey)) continue;
                this.internalConfig.put(configKey, config.get(configKey));
            }
        }
        if ((bufferSize = this.getInt(BUFFER_LENGTH)) <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.maxSize = this.getInt(MAX_STRING_LENGTH);
        this.bufferProvider = this.getBufferProvider().newCharProvider(bufferSize);
        this.valueBufferProvider = this.getBufferProvider().newCharProvider(this.maxSize);
    }

    private BufferStrategy getBufferProvider() {
        Object name = this.internalConfig.get(BUFFER_STRATEGY);
        if (name != null) {
            return BufferStrategy.valueOf(name.toString().toUpperCase(Locale.ENGLISH));
        }
        return BufferStrategy.QUEUE;
    }

    private int getInt(String key) {
        Object maxStringSize = this.internalConfig.get(key);
        if (maxStringSize == null) {
            return DEFAULT_MAX_SIZE;
        }
        if (Number.class.isInstance(maxStringSize)) {
            return ((Number)Number.class.cast(maxStringSize)).intValue();
        }
        return Integer.parseInt(maxStringSize.toString());
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in) {
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in, Charset charset) {
        return new JsonStreamParserImpl(in, charset, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(Reader in) {
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    public JsonParser createParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    public JsonParser createParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    public JsonParser createParser(JsonObject obj) {
        return new JsonInMemoryParser(obj);
    }

    public JsonParser createParser(JsonArray array) {
        return new JsonInMemoryParser(array);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    public JsonParser createInternalParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    public JsonParser createInternalParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    public JsonParser createInternalParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }
}

