/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentMap;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonGeneratorImpl;

final class JsonPrettyGeneratorImpl
extends JsonGeneratorImpl {
    private static final String DEFAULT_INDENTATION = "  ";
    private final String indent;

    public JsonPrettyGeneratorImpl(Writer writer, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        super(writer, bufferProvider, cache);
        this.indent = DEFAULT_INDENTATION;
    }

    public JsonPrettyGeneratorImpl(OutputStream out, Charset encoding, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        super(out, encoding, bufferProvider, cache);
        this.indent = DEFAULT_INDENTATION;
    }

    public JsonPrettyGeneratorImpl(OutputStream out, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        super(out, bufferProvider, cache);
        this.indent = DEFAULT_INDENTATION;
    }

    private void writeEOL() {
        this.justWrite('\n');
    }

    private void writeIndent(int correctionOffset) {
        for (int i = 0; i < this.depth + correctionOffset; ++i) {
            this.justWrite(this.indent);
        }
    }

    @Override
    protected void addCommaIfNeeded() {
        if (this.needComma) {
            this.justWrite(',');
            this.writeEOL();
            this.writeIndent(0);
            this.needComma = false;
        }
    }

    @Override
    public JsonGenerator writeStartObject() {
        if (this.depth > 0 && !this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeStartObject();
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeStartObject(name);
    }

    @Override
    public JsonGenerator writeStartArray() {
        if (this.depth > 0 && !this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeStartArray();
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeStartArray(name);
    }

    @Override
    public JsonGenerator writeEnd() {
        this.writeEOL();
        this.writeIndent(-1);
        return super.writeEnd();
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, String value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, BigInteger value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, BigDecimal value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, int value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, long value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, double value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator write(String name, boolean value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(name, value);
    }

    @Override
    public JsonGenerator writeNull(String name) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeNull(name);
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(String value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(BigDecimal value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(BigInteger value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(int value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(long value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(double value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator write(boolean value) {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.write(value);
    }

    @Override
    public JsonGenerator writeNull() {
        if (!this.needComma) {
            this.writeEOL();
            this.writeIndent(0);
        }
        return super.writeNull();
    }
}

