/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonReaderFactoryImpl;
import org.apache.johnzon.core.JsonWriterFactoryImpl;
import org.apache.johnzon.core.JsonWriterImpl;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private static final JsonProvider DELEGATE = new JsonProviderDelegate();

    public JsonParser createParser(Reader reader) {
        return DELEGATE.createParser(reader);
    }

    public JsonParser createParser(InputStream inputStream) {
        return DELEGATE.createParser(inputStream);
    }

    public JsonParserFactory createParserFactory(Map<String, ?> stringMap) {
        return DELEGATE.createParserFactory(stringMap);
    }

    public JsonGenerator createGenerator(Writer writer) {
        return DELEGATE.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        return DELEGATE.createGenerator(outputStream);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> stringMap) {
        return DELEGATE.createGeneratorFactory(stringMap);
    }

    public JsonReader createReader(Reader reader) {
        return DELEGATE.createReader(reader);
    }

    public JsonReader createReader(InputStream inputStream) {
        return DELEGATE.createReader(inputStream);
    }

    public JsonWriter createWriter(Writer writer) {
        return DELEGATE.createWriter(writer);
    }

    public JsonWriter createWriter(OutputStream outputStream) {
        return DELEGATE.createWriter(outputStream);
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> stringMap) {
        return DELEGATE.createWriterFactory(stringMap);
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createReaderFactory(stringMap);
    }

    public JsonObjectBuilder createObjectBuilder() {
        return DELEGATE.createObjectBuilder();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return DELEGATE.createArrayBuilder();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createBuilderFactory(stringMap);
    }

    static class JsonProviderDelegate
    extends JsonProvider {
        private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(Collections.emptyMap());
        private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(Collections.emptyMap());
        private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(Collections.emptyMap());
        private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

        JsonProviderDelegate() {
        }

        public JsonParser createParser(InputStream in) {
            return this.parserFactory.createParser(in);
        }

        public JsonParser createParser(Reader reader) {
            return this.parserFactory.createParser(reader);
        }

        public JsonReader createReader(InputStream in) {
            return this.readerFactory.createReader(in);
        }

        public JsonReader createReader(Reader reader) {
            return this.readerFactory.createReader(reader);
        }

        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return new JsonParserFactoryImpl(config);
        }

        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return new JsonReaderFactoryImpl(config);
        }

        public JsonGenerator createGenerator(Writer writer) {
            return this.generatorFactory.createGenerator(writer);
        }

        public JsonGenerator createGenerator(OutputStream out) {
            return this.generatorFactory.createGenerator(out);
        }

        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return new JsonGeneratorFactoryImpl(config);
        }

        public JsonWriter createWriter(Writer writer) {
            return new JsonWriterImpl(this.createGenerator(writer));
        }

        public JsonWriter createWriter(OutputStream out) {
            return this.createWriter(new OutputStreamWriter(out, UTF8_CHARSET));
        }

        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return new JsonWriterFactoryImpl(config);
        }

        public JsonObjectBuilder createObjectBuilder() {
            return new JsonObjectBuilderImpl();
        }

        public JsonArrayBuilder createArrayBuilder() {
            return new JsonArrayBuilderImpl();
        }

        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return new JsonBuilderFactoryImpl(config);
        }
    }
}

