/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonReaderImpl;

class JsonReaderFactoryImpl
implements JsonReaderFactory,
Serializable {
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final String[] SUPPORTED_CONFIG_KEYS = new String[]{"org.apache.johnzon.buffer-strategy", "org.apache.johnzon.max-string-length", "org.apache.johnzon.default-char-buffer"};
    private final JsonParserFactoryImpl parserFactory;

    JsonReaderFactoryImpl(Map<String, ?> config) {
        if (config != null) {
            for (String configKey : SUPPORTED_CONFIG_KEYS) {
                if (!config.containsKey(configKey)) continue;
                this.internalConfig.put(configKey, config.get(configKey));
            }
        }
        this.parserFactory = new JsonParserFactoryImpl(this.internalConfig);
    }

    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(reader));
    }

    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in));
    }

    public JsonReader createReader(InputStream in, Charset charset) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

