/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonWriterImpl;

class JsonWriterFactoryImpl
implements JsonWriterFactory,
Serializable {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final String[] SUPPORTED_CONFIG_KEYS = new String[]{"javax.json.stream.JsonGenerator.prettyPrinting"};
    private final JsonGeneratorFactory factory;

    JsonWriterFactoryImpl(Map<String, ?> config) {
        if (config != null) {
            for (String configKey : SUPPORTED_CONFIG_KEYS) {
                if (!config.containsKey(configKey)) continue;
                this.internalConfig.put(configKey, config.get(configKey));
            }
        }
        this.factory = new JsonGeneratorFactoryImpl(this.internalConfig);
    }

    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(this.factory.createGenerator(writer));
    }

    public JsonWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out, UTF8_CHARSET));
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

