/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import javax.json.JsonException;

final class RFC4627AwareInputStreamReader
extends InputStreamReader {
    RFC4627AwareInputStreamReader(InputStream in) {
        this(new PushbackInputStream(in, 4));
    }

    private RFC4627AwareInputStreamReader(PushbackInputStream in) {
        super((InputStream)in, RFC4627AwareInputStreamReader.getCharset(in).newDecoder());
    }

    private static Charset getCharset(PushbackInputStream inputStream) {
        Charset charset = Charset.forName("UTF-8");
        byte[] utfBytes = new byte[4];
        int bomLength = 0;
        try {
            int read = inputStream.read(utfBytes);
            if (read < 2) {
                throw new JsonException("Invalid Json. Valid Json has at least 2 bytes");
            }
            int first = utfBytes[0] & 0xFF;
            int second = utfBytes[1] & 0xFF;
            if (first == 0) {
                charset = second == 0 ? Charset.forName("UTF-32BE") : Charset.forName("UTF-16BE");
            } else if (read > 2 && second == 0) {
                int third = utfBytes[2] & 0xFF;
                charset = third == 0 ? Charset.forName("UTF-32LE") : Charset.forName("UTF-16LE");
            } else if (first == 254 && second == 255) {
                charset = Charset.forName("UTF-16BE");
                bomLength = 2;
            } else if (read > 3 && first == 0 && second == 0 && (utfBytes[2] & 0xFF) == 254 && (utfBytes[3] & 0xFF) == 255) {
                charset = Charset.forName("UTF-32BE");
                bomLength = 4;
            } else if (first == 255 && second == 254) {
                if (read > 3 && (utfBytes[2] & 0xFF) == 0 && (utfBytes[3] & 0xFF) == 0) {
                    charset = Charset.forName("UTF-32LE");
                    bomLength = 4;
                } else {
                    charset = Charset.forName("UTF-16LE");
                    bomLength = 2;
                }
            }
            if (bomLength < 4) {
                inputStream.unread(utfBytes, bomLength == 2 ? 2 : 0, read - bomLength);
            }
        }
        catch (IOException e) {
            throw new JsonException("Unable to detect charset due to " + e.getMessage(), (Throwable)e);
        }
        return charset;
    }
}

