/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.json.JsonStructure;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.johnzon.jaxrs.Jsons;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

@Provider
@Produces(value={"*/*"})
public class JohnzonMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    private final Mapper mapper;

    public JohnzonMessageBodyWriter() {
        this(new MapperBuilder().setDoCloseOnStreams(false).build());
    }

    public JohnzonMessageBodyWriter(Mapper mapper) {
        this.mapper = mapper;
    }

    public long getSize(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Jsons.isJson(mediaType) && InputStream.class != rawType && OutputStream.class != rawType && Writer.class != rawType && StreamingOutput.class != rawType && String.class != rawType && Response.class != rawType && !JsonStructure.class.isAssignableFrom(rawType);
    }

    public void writeTo(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (rawType.isArray()) {
            this.mapper.writeArray(t, entityStream);
        } else if (Collection.class.isAssignableFrom(rawType) && ParameterizedType.class.isInstance(genericType)) {
            this.mapper.writeArray((Collection)Collection.class.cast(t), entityStream);
        } else {
            this.mapper.writeObject(t, entityStream);
        }
    }
}

