/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.access.AccessMode;

public class Mappings {
    protected final ConcurrentMap<Type, ClassMapping> classes = new ConcurrentHashMap<Type, ClassMapping>();
    protected final ConcurrentMap<Type, CollectionMapping> collections = new ConcurrentHashMap<Type, CollectionMapping>();
    protected final Comparator<String> fieldOrdering;
    private final boolean supportHiddenConstructors;
    private final AccessMode accessMode;

    public Mappings(Comparator<String> attributeOrder, AccessMode accessMode, boolean supportHiddenConstructors) {
        this.fieldOrdering = attributeOrder;
        this.accessMode = accessMode;
        this.supportHiddenConstructors = supportHiddenConstructors;
    }

    public <T> CollectionMapping findCollectionMapping(ParameterizedType genericType) {
        CollectionMapping collectionMapping = (CollectionMapping)this.collections.get(genericType);
        if (collectionMapping == null) {
            collectionMapping = this.createCollectionMapping(genericType);
            if (collectionMapping == null) {
                return null;
            }
            CollectionMapping existing = this.collections.putIfAbsent(genericType, collectionMapping);
            if (existing != null) {
                collectionMapping = existing;
            }
        }
        return collectionMapping;
    }

    private <T> CollectionMapping createCollectionMapping(ParameterizedType aType) {
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        Type raw = aType.getRawType();
        if (fieldArgTypes.length == 1 && Class.class.isInstance(raw)) {
            Class collectionType;
            Class r = (Class)Class.class.cast(raw);
            if (List.class.isAssignableFrom(r)) {
                collectionType = List.class;
            } else if (SortedSet.class.isAssignableFrom(r)) {
                collectionType = SortedSet.class;
            } else if (Set.class.isAssignableFrom(r)) {
                collectionType = Set.class;
            } else if (Queue.class.isAssignableFrom(r)) {
                collectionType = Queue.class;
            } else if (Collection.class.isAssignableFrom(r)) {
                collectionType = Collection.class;
            } else {
                return null;
            }
            CollectionMapping mapping = new CollectionMapping(Mappings.isPrimitive(fieldArgTypes[0]), collectionType, fieldArgTypes[0]);
            this.collections.putIfAbsent(aType, mapping);
            return mapping;
        }
        return null;
    }

    public static boolean isPrimitive(Type type) {
        if (type == String.class) {
            return true;
        }
        if (type == Character.TYPE || type == Character.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    public ClassMapping getClassMapping(Type clazz) {
        return (ClassMapping)this.classes.get(clazz);
    }

    public ClassMapping findOrCreateClassMapping(Type clazz) {
        ClassMapping classMapping = (ClassMapping)this.classes.get(clazz);
        if (classMapping == null) {
            if (!Class.class.isInstance(clazz) || Map.class.isAssignableFrom((Class)Class.class.cast(clazz))) {
                return null;
            }
            classMapping = this.createClassMapping((Class)Class.class.cast(clazz));
            ClassMapping existing = this.classes.putIfAbsent(clazz, classMapping);
            if (existing != null) {
                classMapping = existing;
            }
        }
        return classMapping;
    }

    private ClassMapping createClassMapping(Class<?> clazz) {
        AccessMode.DecoratedType value;
        TreeMap<String, Getter> getters = this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
        TreeMap<String, Setter> setters = this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
        for (Map.Entry<String, AccessMode.Reader> entry : this.accessMode.findReaders(clazz).entrySet()) {
            value = entry.getValue();
            JohnzonIgnore readIgnore = value.getAnnotation(JohnzonIgnore.class);
            if (readIgnore != null && readIgnore.minVersion() < 0) continue;
            Class returnType = Class.class.isInstance(value.getType()) ? (Class)Class.class.cast(value.getType()) : null;
            ParameterizedType pt = ParameterizedType.class.isInstance(value.getType()) ? (ParameterizedType)ParameterizedType.class.cast(value.getType()) : null;
            getters.put(entry.getKey(), new Getter((AccessMode.Reader)value, Mappings.isPrimitive(returnType), returnType != null && returnType.isArray(), pt != null && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Collection.class.isAssignableFrom(returnType), pt != null && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Map.class.isAssignableFrom(returnType), Mappings.findConverter(value), readIgnore != null ? readIgnore.minVersion() : -1));
        }
        for (Map.Entry<String, AccessMode.DecoratedType> entry : this.accessMode.findWriters(clazz).entrySet()) {
            String key;
            value = (AccessMode.Writer)entry.getValue();
            JohnzonIgnore writeIgnore = value.getAnnotation(JohnzonIgnore.class);
            if (writeIgnore != null && writeIgnore.minVersion() < 0 || (key = entry.getKey()).equals("metaClass")) continue;
            Type param = value.getType();
            setters.put(key, new Setter((AccessMode.Writer)value, Mappings.isPrimitive(param), param, Mappings.findConverter(value), writeIgnore != null ? writeIgnore.minVersion() : -1));
        }
        return new ClassMapping(clazz, getters, setters, this.supportHiddenConstructors);
    }

    private static Converter findConverter(AccessMode.DecoratedType method) {
        Converter<?> converter = null;
        if (method.getAnnotation(JohnzonConverter.class) != null) {
            try {
                converter = method.getAnnotation(JohnzonConverter.class).value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return converter;
    }

    public static class Setter {
        public final AccessMode.Writer writer;
        public final int version;
        public final Type paramType;
        public final Converter<?> converter;
        public final boolean primitive;

        public Setter(AccessMode.Writer writer, boolean primitive, Type paramType, Converter<?> converter, int version) {
            this.writer = writer;
            this.paramType = paramType;
            this.converter = converter;
            this.version = version;
            this.primitive = primitive;
        }
    }

    public static class Getter {
        public final AccessMode.Reader reader;
        public final int version;
        public final Converter<Object> converter;
        public final boolean primitive;
        public final boolean array;
        public final boolean map;
        public final boolean collection;

        public Getter(AccessMode.Reader reader, boolean primitive, boolean array, boolean collection, boolean map, Converter<Object> converter, int version) {
            this.reader = reader;
            this.converter = converter;
            this.version = version;
            this.array = array;
            this.map = map && converter == null;
            this.collection = collection;
            this.primitive = primitive;
        }
    }

    public static class CollectionMapping {
        public final Class<?> raw;
        public final Type arg;
        public final boolean primitive;

        public CollectionMapping(boolean primitive, Class<?> collectionType, Type fieldArgType) {
            this.raw = collectionType;
            this.arg = fieldArgType;
            this.primitive = primitive;
        }
    }

    public static class ClassMapping {
        public final Class<?> clazz;
        public final Map<String, Getter> getters;
        public final Map<String, Setter> setters;
        public final Constructor<?> constructor;

        protected ClassMapping(Class<?> clazz, Map<String, Getter> getters, Map<String, Setter> setters, boolean acceptHiddenConstructor) {
            this.clazz = clazz;
            this.getters = getters;
            this.setters = setters;
            this.constructor = this.findConstructor(acceptHiddenConstructor);
        }

        private Constructor<?> findConstructor(boolean acceptHiddenConstructor) {
            for (Constructor<?> c : this.clazz.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != 0) continue;
                if (!Modifier.isPublic(c.getModifiers()) && acceptHiddenConstructor) {
                    c.setAccessible(true);
                }
                return c;
            }
            try {
                return this.clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

