/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.johnzon.mapper.MappingGenerator;

public class DynamicMappingGenerator
implements MappingGenerator {
    private final MappingGenerator delegate;
    private final Runnable writeStart;
    private final Runnable writeEnd;
    private final String keyName;
    private InObjectOrPrimitiveJsonGenerator generator;

    public DynamicMappingGenerator(MappingGenerator delegate, Runnable writeStart, Runnable writeEnd, String keyName) {
        this.delegate = delegate;
        this.writeStart = writeStart;
        this.writeEnd = writeEnd;
        this.keyName = keyName;
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        return this.generator == null ? (this.generator = new InObjectOrPrimitiveJsonGenerator(this.delegate.getJsonGenerator(), this.writeStart, this.keyName)) : this.generator;
    }

    @Override
    public MappingGenerator writeObject(String key, Object o, JsonGenerator generator) {
        return this.delegate.writeObject(key, o, this.ensureGenerator(generator));
    }

    @Override
    public MappingGenerator writeObject(Object o, JsonGenerator generator) {
        return this.delegate.writeObject(o, this.ensureGenerator(generator));
    }

    private JsonGenerator ensureGenerator(JsonGenerator generator) {
        if (this.generator != null && this.generator != generator && this.generator.delegate != generator) {
            this.generator = null;
        }
        return this.getJsonGenerator();
    }

    public void flushIfNeeded() {
        if (this.generator.state == WritingState.WROTE_START) {
            this.writeEnd.run();
            this.generator.state = WritingState.NONE;
        }
    }

    private static class InObjectOrPrimitiveJsonGenerator
    implements JsonGenerator {
        private final JsonGenerator delegate;
        private final Runnable writeStart;
        private final String keyIfNoObject;
        private WritingState state = WritingState.NONE;
        private int nested = 0;

        private InObjectOrPrimitiveJsonGenerator(JsonGenerator generator, Runnable writeStart, String keyName) {
            this.delegate = generator;
            this.writeStart = writeStart;
            this.keyIfNoObject = keyName;
        }

        private void ensureStart() {
            if (this.state != WritingState.NONE) {
                return;
            }
            this.writeStart.run();
            this.state = WritingState.WROTE_START;
        }

        public JsonGenerator writeStartObject() {
            if (this.state == WritingState.NONE) {
                this.ensureStart();
            } else {
                ++this.nested;
                this.delegate.writeStartObject();
            }
            return this;
        }

        public JsonGenerator writeStartObject(String name) {
            if (this.state == WritingState.NONE) {
                this.ensureStart();
            }
            ++this.nested;
            this.delegate.writeStartObject(name);
            return this;
        }

        public JsonGenerator writeStartArray() {
            if (this.state != WritingState.NONE) {
                ++this.nested;
            }
            if (this.keyIfNoObject != null && this.state == WritingState.NONE) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.writeStartArray(this.keyIfNoObject);
            }
            if (this.state == WritingState.NONE) {
                this.ensureStart();
                return this;
            }
            this.delegate.writeStartArray();
            return this;
        }

        public JsonGenerator writeStartArray(String name) {
            if (this.state != WritingState.NONE) {
                ++this.nested;
            }
            this.ensureStart();
            this.delegate.writeStartArray(name);
            return this;
        }

        public JsonGenerator writeKey(String name) {
            this.ensureStart();
            this.delegate.writeKey(name);
            return this;
        }

        public JsonGenerator write(String name, JsonValue value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, String value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigInteger value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, BigDecimal value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, int value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, long value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, double value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator write(String name, boolean value) {
            this.ensureStart();
            this.delegate.write(name, value);
            return this;
        }

        public JsonGenerator writeNull(String name) {
            this.ensureStart();
            this.delegate.writeNull(name);
            return this;
        }

        public JsonGenerator writeEnd() {
            if (this.nested == 0 && this.state == WritingState.WROTE_START) {
                this.state = WritingState.NONE;
            }
            if (this.nested > 0) {
                --this.nested;
            }
            this.delegate.writeEnd();
            return this;
        }

        public JsonGenerator write(JsonValue value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(String value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigDecimal value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(BigInteger value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(int value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(long value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(double value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator write(boolean value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.write(this.keyIfNoObject, value);
                return this;
            }
            this.delegate.write(value);
            return this;
        }

        public JsonGenerator writeNull() {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                this.delegate.writeNull(this.keyIfNoObject);
                return this;
            }
            this.delegate.writeNull();
            return this;
        }

        private boolean isWritingPrimitive() {
            return this.state == WritingState.NONE && this.keyIfNoObject != null;
        }

        public void close() {
            this.delegate.close();
        }

        public void flush() {
            this.delegate.flush();
        }
    }

    private static enum WritingState {
        NONE,
        WROTE_START,
        DONT_WRITE_END;

    }
}

