/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsResponse;

public class CreateTopicsRequest
extends AbstractRequest {
    private static final String REQUESTS_KEY_NAME = "create_topic_requests";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String VALIDATE_ONLY_KEY_NAME = "validate_only";
    private static final String NUM_PARTITIONS_KEY_NAME = "num_partitions";
    private static final String REPLICATION_FACTOR_KEY_NAME = "replication_factor";
    private static final String REPLICA_ASSIGNMENT_KEY_NAME = "replica_assignment";
    private static final String REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME = "replicas";
    private static final String CONFIG_NAME_KEY_NAME = "config_name";
    private static final String CONFIG_VALUE_KEY_NAME = "config_value";
    private static final String CONFIG_ENTRIES_KEY_NAME = "config_entries";
    private static final Schema CONFIG_ENTRY = new Schema(new Field("config_name", Type.STRING, "Configuration name"), new Field("config_value", Type.NULLABLE_STRING, "Configuration value"));
    private static final Schema PARTITION_REPLICA_ASSIGNMENT_ENTRY = new Schema(CommonFields.PARTITION_ID, new Field("replicas", new ArrayOf(Type.INT32), "The set of all nodes that should host this partition. The first replica in the list is the preferred leader."));
    private static final Schema SINGLE_CREATE_TOPIC_REQUEST_V0;
    private static final Schema SINGLE_CREATE_TOPIC_REQUEST_V1;
    private static final Schema CREATE_TOPICS_REQUEST_V0;
    private static final Schema CREATE_TOPICS_REQUEST_V1;
    private static final Schema CREATE_TOPICS_REQUEST_V2;
    private static final Schema CREATE_TOPICS_REQUEST_V3;
    private final Map<String, TopicDetails> topics;
    private final Integer timeout;
    private final boolean validateOnly;
    private final Set<String> duplicateTopics;
    public static final int NO_NUM_PARTITIONS = -1;
    public static final short NO_REPLICATION_FACTOR = -1;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_TOPICS_REQUEST_V0, CREATE_TOPICS_REQUEST_V1, CREATE_TOPICS_REQUEST_V2, CREATE_TOPICS_REQUEST_V3};
    }

    private CreateTopicsRequest(Map<String, TopicDetails> topics, Integer timeout, boolean validateOnly, short version) {
        super(ApiKeys.CREATE_TOPICS, version);
        this.topics = topics;
        this.timeout = timeout;
        this.validateOnly = validateOnly;
        this.duplicateTopics = Collections.emptySet();
    }

    public CreateTopicsRequest(Struct struct, short version) {
        super(ApiKeys.CREATE_TOPICS, version);
        Object[] requestStructs = struct.getArray(REQUESTS_KEY_NAME);
        HashMap<String, TopicDetails> topics = new HashMap<String, TopicDetails>();
        HashSet<String> duplicateTopics = new HashSet<String>();
        for (Object requestStructObj : requestStructs) {
            Struct singleRequestStruct = (Struct)requestStructObj;
            String topic = singleRequestStruct.get(CommonFields.TOPIC_NAME);
            if (topics.containsKey(topic)) {
                duplicateTopics.add(topic);
            }
            int numPartitions = singleRequestStruct.getInt(NUM_PARTITIONS_KEY_NAME);
            short replicationFactor = singleRequestStruct.getShort(REPLICATION_FACTOR_KEY_NAME);
            Object[] assignmentsArray = singleRequestStruct.getArray(REPLICA_ASSIGNMENT_KEY_NAME);
            HashMap partitionReplicaAssignments = new HashMap(assignmentsArray.length);
            for (Object assignmentStructObj : assignmentsArray) {
                Struct assignmentStruct = (Struct)assignmentStructObj;
                Integer partitionId = assignmentStruct.get(CommonFields.PARTITION_ID);
                Object[] replicasArray = assignmentStruct.getArray(REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME);
                ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
                for (Object replica : replicasArray) {
                    replicas.add((Integer)replica);
                }
                partitionReplicaAssignments.put(partitionId, replicas);
            }
            Object[] configArray = singleRequestStruct.getArray(CONFIG_ENTRIES_KEY_NAME);
            HashMap<String, String> configs = new HashMap<String, String>(configArray.length);
            for (Object configStructObj : configArray) {
                Struct configStruct = (Struct)configStructObj;
                String key = configStruct.getString(CONFIG_NAME_KEY_NAME);
                String value = configStruct.getString(CONFIG_VALUE_KEY_NAME);
                configs.put(key, value);
            }
            TopicDetails args = new TopicDetails(numPartitions, replicationFactor, partitionReplicaAssignments, configs);
            topics.put(topic, args);
        }
        this.topics = topics;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
        this.validateOnly = struct.hasField(VALIDATE_ONLY_KEY_NAME) ? struct.getBoolean(VALIDATE_ONLY_KEY_NAME) : false;
        this.duplicateTopics = duplicateTopics;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<String, ApiError> topicErrors = new HashMap<String, ApiError>();
        for (String topic : this.topics.keySet()) {
            topicErrors.put(topic, ApiError.fromThrowable(e));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new CreateTopicsResponse(topicErrors);
            }
            case 2: 
            case 3: {
                return new CreateTopicsResponse(throttleTimeMs, topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CREATE_TOPICS.latestVersion()));
    }

    public Map<String, TopicDetails> topics() {
        return this.topics;
    }

    public int timeout() {
        return this.timeout;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public Set<String> duplicateTopics() {
        return this.duplicateTopics;
    }

    public static CreateTopicsRequest parse(ByteBuffer buffer, short version) {
        return new CreateTopicsRequest(ApiKeys.CREATE_TOPICS.parseRequest(version, buffer), version);
    }

    @Override
    public Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.CREATE_TOPICS.requestSchema(version));
        ArrayList<Struct> createTopicRequestStructs = new ArrayList<Struct>(this.topics.size());
        for (Map.Entry<String, TopicDetails> entry : this.topics.entrySet()) {
            Struct singleRequestStruct = struct.instance(REQUESTS_KEY_NAME);
            String topic = entry.getKey();
            TopicDetails args = entry.getValue();
            singleRequestStruct.set(CommonFields.TOPIC_NAME, topic);
            singleRequestStruct.set(NUM_PARTITIONS_KEY_NAME, (Object)args.numPartitions);
            singleRequestStruct.set(REPLICATION_FACTOR_KEY_NAME, (Object)args.replicationFactor);
            ArrayList<Struct> replicaAssignmentsStructs = new ArrayList<Struct>(args.replicasAssignments.size());
            for (Map.Entry<Integer, List<Integer>> partitionReplicaAssignment : args.replicasAssignments.entrySet()) {
                Struct replicaAssignmentStruct = singleRequestStruct.instance(REPLICA_ASSIGNMENT_KEY_NAME);
                replicaAssignmentStruct.set(CommonFields.PARTITION_ID, partitionReplicaAssignment.getKey());
                replicaAssignmentStruct.set(REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME, (Object)partitionReplicaAssignment.getValue().toArray());
                replicaAssignmentsStructs.add(replicaAssignmentStruct);
            }
            singleRequestStruct.set(REPLICA_ASSIGNMENT_KEY_NAME, (Object)replicaAssignmentsStructs.toArray());
            ArrayList<Struct> configsStructs = new ArrayList<Struct>(args.configs.size());
            for (Map.Entry<String, String> configEntry : args.configs.entrySet()) {
                Struct configStruct = singleRequestStruct.instance(CONFIG_ENTRIES_KEY_NAME);
                configStruct.set(CONFIG_NAME_KEY_NAME, (Object)configEntry.getKey());
                configStruct.set(CONFIG_VALUE_KEY_NAME, (Object)configEntry.getValue());
                configsStructs.add(configStruct);
            }
            singleRequestStruct.set(CONFIG_ENTRIES_KEY_NAME, (Object)configsStructs.toArray());
            createTopicRequestStructs.add(singleRequestStruct);
        }
        struct.set(REQUESTS_KEY_NAME, (Object)createTopicRequestStructs.toArray());
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        if (version >= 1) {
            struct.set(VALIDATE_ONLY_KEY_NAME, (Object)this.validateOnly);
        }
        return struct;
    }

    static {
        SINGLE_CREATE_TOPIC_REQUEST_V1 = SINGLE_CREATE_TOPIC_REQUEST_V0 = new Schema(CommonFields.TOPIC_NAME, new Field(NUM_PARTITIONS_KEY_NAME, Type.INT32, "Number of partitions to be created. -1 indicates unset."), new Field(REPLICATION_FACTOR_KEY_NAME, Type.INT16, "Replication factor for the topic. -1 indicates unset."), new Field(REPLICA_ASSIGNMENT_KEY_NAME, new ArrayOf(PARTITION_REPLICA_ASSIGNMENT_ENTRY), "Replica assignment among kafka brokers for this topic partitions. If this is set num_partitions and replication_factor must be unset."), new Field(CONFIG_ENTRIES_KEY_NAME, new ArrayOf(CONFIG_ENTRY), "Topic level configuration for topic to be set."));
        CREATE_TOPICS_REQUEST_V0 = new Schema(new Field(REQUESTS_KEY_NAME, new ArrayOf(SINGLE_CREATE_TOPIC_REQUEST_V0), "An array of single topic creation requests. Can not have multiple entries for the same topic."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time in ms to wait for a topic to be completely created on the controller node. Values <= 0 will trigger topic creation and return immediately"));
        CREATE_TOPICS_REQUEST_V3 = CREATE_TOPICS_REQUEST_V2 = (CREATE_TOPICS_REQUEST_V1 = new Schema(new Field(REQUESTS_KEY_NAME, new ArrayOf(SINGLE_CREATE_TOPIC_REQUEST_V1), "An array of single topic creation requests. Can not have multiple entries for the same topic."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time in ms to wait for a topic to be completely created on the controller node. Values <= 0 will trigger topic creation and return immediately"), new Field(VALIDATE_ONLY_KEY_NAME, Type.BOOLEAN, "If this is true, the request will be validated, but the topic won't be created.")));
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateTopicsRequest> {
        private final Map<String, TopicDetails> topics;
        private final int timeout;
        private final boolean validateOnly;

        public Builder(Map<String, TopicDetails> topics, int timeout) {
            this(topics, timeout, false);
        }

        public Builder(Map<String, TopicDetails> topics, int timeout, boolean validateOnly) {
            super(ApiKeys.CREATE_TOPICS);
            this.topics = topics;
            this.timeout = timeout;
            this.validateOnly = validateOnly;
        }

        @Override
        public CreateTopicsRequest build(short version) {
            if (this.validateOnly && version == 0) {
                throw new UnsupportedVersionException("validateOnly is not supported in version 0 of CreateTopicsRequest");
            }
            return new CreateTopicsRequest(this.topics, this.timeout, this.validateOnly, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=CreateTopicsRequest").append(", topics=").append(this.topics).append(", timeout=").append(this.timeout).append(", validateOnly=").append(this.validateOnly).append(")");
            return bld.toString();
        }
    }

    public static final class TopicDetails {
        public final int numPartitions;
        public final short replicationFactor;
        public final Map<Integer, List<Integer>> replicasAssignments;
        public final Map<String, String> configs;

        private TopicDetails(int numPartitions, short replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.replicasAssignments = replicasAssignments;
            this.configs = configs;
        }

        public TopicDetails(int partitions, short replicationFactor, Map<String, String> configs) {
            this(partitions, replicationFactor, Collections.emptyMap(), configs);
        }

        public TopicDetails(int partitions, short replicationFactor) {
            this(partitions, replicationFactor, Collections.emptyMap());
        }

        public TopicDetails(Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this(-1, -1, replicasAssignments, configs);
        }

        public TopicDetails(Map<Integer, List<Integer>> replicasAssignments) {
            this(replicasAssignments, Collections.emptyMap());
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(numPartitions=").append(this.numPartitions).append(", replicationFactor=").append(this.replicationFactor).append(", replicasAssignments=").append(this.replicasAssignments).append(", configs=").append(this.configs).append(")");
            return bld.toString();
        }
    }
}

