/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class WriteTxnMarkersResponseData
implements ApiMessage {
    private List<WritableTxnMarkerResult> markers = new ArrayList<WritableTxnMarkerResult>();
    public static final Schema SCHEMA_0 = new Schema(new Field("markers", new ArrayOf(WritableTxnMarkerResult.SCHEMA_0), "The results for writing makers."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public WriteTxnMarkersResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public WriteTxnMarkersResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public WriteTxnMarkersResponseData() {
    }

    @Override
    public short apiKey() {
        return 27;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.markers = null;
        } else {
            this.markers.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.markers.add(new WritableTxnMarkerResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.markers.size());
        for (WritableTxnMarkerResult element : this.markers) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("markers");
        this.markers = new ArrayList<WritableTxnMarkerResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.markers.add(new WritableTxnMarkerResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.markers.size()];
        int i = 0;
        for (WritableTxnMarkerResult element : this.markers) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("markers", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (WritableTxnMarkerResult element : this.markers) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WriteTxnMarkersResponseData)) {
            return false;
        }
        WriteTxnMarkersResponseData other = (WriteTxnMarkersResponseData)obj;
        return !(this.markers == null ? other.markers != null : !this.markers.equals(other.markers));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.markers == null ? 0 : this.markers.hashCode());
        return hashCode;
    }

    public String toString() {
        return "WriteTxnMarkersResponseData(markers=" + MessageUtil.deepToString(this.markers.iterator()) + ")";
    }

    public List<WritableTxnMarkerResult> markers() {
        return this.markers;
    }

    public WriteTxnMarkersResponseData setMarkers(List<WritableTxnMarkerResult> v) {
        this.markers = v;
        return this;
    }

    public static class WritableTxnMarkerPartitionResult
    implements Message {
        private int partitionIndex;
        private short errorCode;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerPartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public WritableTxnMarkerPartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public WritableTxnMarkerPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerPartitionResult)) {
                return false;
            }
            WritableTxnMarkerPartitionResult other = (WritableTxnMarkerPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public WritableTxnMarkerPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public WritableTxnMarkerPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }
    }

    public static class WritableTxnMarkerTopicResult
    implements Message {
        private String name;
        private List<WritableTxnMarkerPartitionResult> partitions;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(WritableTxnMarkerPartitionResult.SCHEMA_0), "The results by partition."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerTopicResult(Readable readable, short version) {
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>();
            this.read(readable, version);
        }

        public WritableTxnMarkerTopicResult(Struct struct, short version) {
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>();
            this.fromStruct(struct, version);
        }

        public WritableTxnMarkerTopicResult() {
            this.name = "";
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new WritableTxnMarkerPartitionResult(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (WritableTxnMarkerPartitionResult element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<WritableTxnMarkerPartitionResult>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new WritableTxnMarkerPartitionResult((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (WritableTxnMarkerPartitionResult element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (WritableTxnMarkerPartitionResult element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerTopicResult)) {
                return false;
            }
            WritableTxnMarkerTopicResult other = (WritableTxnMarkerTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerTopicResult(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<WritableTxnMarkerPartitionResult> partitions() {
            return this.partitions;
        }

        public WritableTxnMarkerTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public WritableTxnMarkerTopicResult setPartitions(List<WritableTxnMarkerPartitionResult> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class WritableTxnMarkerResult
    implements Message {
        private long producerId;
        private List<WritableTxnMarkerTopicResult> topics;
        public static final Schema SCHEMA_0 = new Schema(new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("topics", new ArrayOf(WritableTxnMarkerTopicResult.SCHEMA_0), "The results by topic."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public WritableTxnMarkerResult(Readable readable, short version) {
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>();
            this.read(readable, version);
        }

        public WritableTxnMarkerResult(Struct struct, short version) {
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>();
            this.fromStruct(struct, version);
        }

        public WritableTxnMarkerResult() {
            this.producerId = 0L;
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.producerId = readable.readLong();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                this.topics.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.topics.add(new WritableTxnMarkerTopicResult(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeLong(this.producerId);
            writable.writeInt(this.topics.size());
            for (WritableTxnMarkerTopicResult element : this.topics) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.producerId = struct.getLong("producer_id");
            Object[] nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<WritableTxnMarkerTopicResult>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new WritableTxnMarkerTopicResult((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("producer_id", (Object)this.producerId);
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (WritableTxnMarkerTopicResult element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 8;
            size += 4;
            for (WritableTxnMarkerTopicResult element : this.topics) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WritableTxnMarkerResult)) {
                return false;
            }
            WritableTxnMarkerResult other = (WritableTxnMarkerResult)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        public String toString() {
            return "WritableTxnMarkerResult(producerId=" + this.producerId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public List<WritableTxnMarkerTopicResult> topics() {
            return this.topics;
        }

        public WritableTxnMarkerResult setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public WritableTxnMarkerResult setTopics(List<WritableTxnMarkerTopicResult> v) {
            this.topics = v;
            return this;
        }
    }
}

